/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.analyzer.beans;

import org.apache.commons.math.stat.descriptive.DescriptiveStatistics;
import org.apache.commons.math.stat.descriptive.StatisticalSummary;
import org.apache.commons.math.stat.descriptive.SummaryStatistics;
import org.eobjects.analyzer.data.InputRow;
import org.eobjects.analyzer.storage.RowAnnotation;
import org.eobjects.analyzer.storage.RowAnnotationFactory;

final class NumberAnalyzerColumnDelegate {
    private final RowAnnotationFactory _annotationFactory;
    private final StatisticalSummary _statistics;
    private volatile int _numRows;
    private final RowAnnotation _nullAnnotation;
    private final RowAnnotation _maxAnnotation;
    private final RowAnnotation _minAnnotation;

    public NumberAnalyzerColumnDelegate(boolean descriptiveStatistics, RowAnnotationFactory annotationFactory) {
        this._annotationFactory = annotationFactory;
        this._nullAnnotation = this._annotationFactory.createAnnotation();
        this._maxAnnotation = this._annotationFactory.createAnnotation();
        this._minAnnotation = this._annotationFactory.createAnnotation();
        this._statistics = descriptiveStatistics ? new DescriptiveStatistics() : new SummaryStatistics();
    }

    public synchronized void run(InputRow row, Number value, int distinctCount) {
        this._numRows += distinctCount;
        if (value != null) {
            double doubleValue = value.doubleValue();
            double max = this._statistics.getMax();
            double min = this._statistics.getMin();
            if (max < doubleValue) {
                this._annotationFactory.reset(this._maxAnnotation);
            }
            if (min > doubleValue) {
                this._annotationFactory.reset(this._minAnnotation);
            }
            for (int i = 0; i < distinctCount; ++i) {
                if (this._statistics instanceof DescriptiveStatistics) {
                    ((DescriptiveStatistics)this._statistics).addValue(doubleValue);
                    continue;
                }
                ((SummaryStatistics)this._statistics).addValue(doubleValue);
            }
            max = this._statistics.getMax();
            min = this._statistics.getMin();
            if (max == doubleValue) {
                this._annotationFactory.annotate(row, distinctCount, this._maxAnnotation);
            }
            if (min == doubleValue) {
                this._annotationFactory.annotate(row, distinctCount, this._minAnnotation);
            }
        } else {
            this._annotationFactory.annotate(row, distinctCount, this._nullAnnotation);
        }
    }

    public RowAnnotation getNullAnnotation() {
        return this._nullAnnotation;
    }

    public StatisticalSummary getStatistics() {
        return this._statistics;
    }

    public int getNullCount() {
        return this._nullAnnotation.getRowCount();
    }

    public RowAnnotation getMaxAnnotation() {
        return this._maxAnnotation;
    }

    public RowAnnotation getMinAnnotation() {
        return this._minAnnotation;
    }

    public int getNumRows() {
        return this._numRows;
    }
}

