/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.analyzer.beans;

import org.eobjects.analyzer.beans.NumberAnalyzerResultReducer;
import org.eobjects.analyzer.beans.api.Distributed;
import org.eobjects.analyzer.data.InputColumn;
import org.eobjects.analyzer.result.Crosstab;
import org.eobjects.analyzer.result.CrosstabResult;
import org.eobjects.analyzer.result.Metric;

@Distributed(reducer=NumberAnalyzerResultReducer.class)
public class NumberAnalyzerResult
extends CrosstabResult {
    private static final long serialVersionUID = 1L;
    private final InputColumn<? extends Number>[] _columns;

    public NumberAnalyzerResult(InputColumn<? extends Number>[] columns, Crosstab<?> crosstab) {
        super(crosstab);
        this._columns = columns;
    }

    public InputColumn<? extends Number>[] getColumns() {
        return this._columns;
    }

    @Metric(order=1, value="Row count")
    public Number getRowCount(InputColumn<?> col) {
        return (Number)this.getCrosstab().where("Column", col.getName()).where("Measure", "Row count").get();
    }

    @Metric(order=2, value="Null count")
    public Number getNullCount(InputColumn<?> col) {
        return (Number)this.getCrosstab().where("Column", col.getName()).where("Measure", "Null count").get();
    }

    @Metric(order=3, value="Highest value")
    public Number getHighestValue(InputColumn<?> col) {
        return (Number)this.getCrosstab().where("Column", col.getName()).where("Measure", "Highest value").safeGet(null);
    }

    @Metric(order=4, value="Lowest value")
    public Number getLowestValue(InputColumn<?> col) {
        return (Number)this.getCrosstab().where("Column", col.getName()).where("Measure", "Lowest value").safeGet(null);
    }

    @Metric(order=5, value="Sum")
    public Number getSum(InputColumn<?> col) {
        return (Number)this.getCrosstab().where("Column", col.getName()).where("Measure", "Sum").safeGet(null);
    }

    @Metric(order=6, value="Mean")
    public Number getMean(InputColumn<?> col) {
        return (Number)this.getCrosstab().where("Column", col.getName()).where("Measure", "Mean").safeGet(null);
    }

    @Metric(order=7, value="Geometric mean")
    public Number getGeometricMean(InputColumn<?> col) {
        return (Number)this.getCrosstab().where("Column", col.getName()).where("Measure", "Geometric mean").safeGet(null);
    }

    @Metric(order=8, value="Standard deviation")
    public Number getStandardDeviation(InputColumn<?> col) {
        return (Number)this.getCrosstab().where("Column", col.getName()).where("Measure", "Standard deviation").safeGet(null);
    }

    @Metric(order=9, value="Variance")
    public Number getVariance(InputColumn<?> col) {
        return (Number)this.getCrosstab().where("Column", col.getName()).where("Measure", "Variance").safeGet(null);
    }

    @Metric(order=10, value="Second moment")
    public Number getSecondMoment(InputColumn<?> col) {
        return (Number)this.getCrosstab().where("Column", col.getName()).where("Measure", "Second moment").safeGet(null);
    }

    @Metric(order=11, value="Sum of squares")
    public Number getSumOfSquares(InputColumn<?> col) {
        return (Number)this.getCrosstab().where("Column", col.getName()).where("Measure", "Sum of squares").safeGet(null);
    }

    @Metric(order=20, value="Median")
    public Number getMedian(InputColumn<?> col) {
        return (Number)this.getCrosstab().where("Column", col.getName()).where("Measure", "Median").safeGet(null);
    }

    @Metric(order=21, value="25th percentile")
    public Number getPercentile25(InputColumn<?> col) {
        return (Number)this.getCrosstab().where("Column", col.getName()).where("Measure", "25th percentile").safeGet(null);
    }

    @Metric(order=22, value="75th percentile")
    public Number getPercentile75(InputColumn<?> col) {
        return (Number)this.getCrosstab().where("Column", col.getName()).where("Measure", "75th percentile").safeGet(null);
    }

    @Metric(order=23, value="Kurtosis")
    public Number getKurtosis(InputColumn<?> col) {
        return (Number)this.getCrosstab().where("Column", col.getName()).where("Measure", "Kurtosis").safeGet(null);
    }

    @Metric(order=24, value="Skewness")
    public Number getSkewness(InputColumn<?> col) {
        return (Number)this.getCrosstab().where("Column", col.getName()).where("Measure", "Skewness").safeGet(null);
    }
}

