/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.analyzer.beans;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.math.stat.descriptive.AggregateSummaryStatistics;
import org.apache.commons.math.stat.descriptive.StatisticalSummary;
import org.apache.commons.math.stat.descriptive.StatisticalSummaryValues;
import org.apache.commons.math.stat.descriptive.SummaryStatistics;
import org.eobjects.analyzer.beans.NumberAnalyzerResult;
import org.eobjects.analyzer.data.InputColumn;
import org.eobjects.analyzer.data.MockInputColumn;
import org.eobjects.analyzer.result.AbstractCrosstabResultReducer;
import org.eobjects.analyzer.result.Crosstab;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NumberAnalyzerResultReducer
extends AbstractCrosstabResultReducer<NumberAnalyzerResult> {
    private static final Logger logger = LoggerFactory.getLogger(NumberAnalyzerResultReducer.class);
    private static final Set<String> SUM_MEASURES = new HashSet<String>(Arrays.asList("Sum", "Row count", "Null count"));

    protected Serializable reduceValues(List<Object> slaveValues, String column, String measure, Collection<? extends NumberAnalyzerResult> results, Class<?> valueClass) {
        if (SUM_MEASURES.contains(measure)) {
            return NumberAnalyzerResultReducer.sum(slaveValues);
        }
        if ("Highest value".equals(measure)) {
            return NumberAnalyzerResultReducer.maximum(slaveValues);
        }
        if ("Lowest value".equals(measure)) {
            return NumberAnalyzerResultReducer.minimum(slaveValues);
        }
        if ("Mean".equals(measure)) {
            StatisticalSummary summary = this.getSummary(column, results);
            return Double.valueOf(summary.getMean());
        }
        if ("Standard deviation".equals(measure)) {
            StatisticalSummary summary = this.getSummary(column, results);
            return Double.valueOf(summary.getStandardDeviation());
        }
        if ("Variance".equals(measure)) {
            StatisticalSummary summary = this.getSummary(column, results);
            return Double.valueOf(summary.getVariance());
        }
        logger.warn("Encountered non-reduceable measure '{}'. Slave values are: {}", (Object)measure, slaveValues);
        return null;
    }

    private StatisticalSummary getSummary(String column, Collection<? extends NumberAnalyzerResult> results) {
        ArrayList<SummaryStatistics> statistics = new ArrayList<SummaryStatistics>(results.size());
        for (NumberAnalyzerResult numberAnalyzerResult : results) {
            SummaryStatistics stats = this.buildStatistics(column, numberAnalyzerResult);
            statistics.add(stats);
        }
        StatisticalSummaryValues summary = AggregateSummaryStatistics.aggregate(statistics);
        return summary;
    }

    private SummaryStatistics buildStatistics(final String column, final NumberAnalyzerResult analyzerResult) {
        SummaryStatistics stats = new SummaryStatistics(){
            private static final long serialVersionUID = 1L;
            private final InputColumn<Number> col;
            {
                this.col = new MockInputColumn(column);
            }

            public long getN() {
                return analyzerResult.getRowCount(this.col).longValue();
            }

            public double getSum() {
                return analyzerResult.getSum(this.col).longValue();
            }

            public double getVariance() {
                return analyzerResult.getVariance(this.col).longValue();
            }

            public double getStandardDeviation() {
                return analyzerResult.getStandardDeviation(this.col).longValue();
            }

            public double getMean() {
                return analyzerResult.getMean(this.col).longValue();
            }

            public double getMin() {
                return analyzerResult.getLowestValue(this.col).longValue();
            }

            public double getMax() {
                return analyzerResult.getHighestValue(this.col).longValue();
            }

            public double getGeometricMean() {
                return analyzerResult.getGeometricMean(this.col).doubleValue();
            }

            public double getSecondMoment() {
                return analyzerResult.getSecondMoment(this.col).doubleValue();
            }

            public double getSumsq() {
                return analyzerResult.getSumOfSquares(this.col).doubleValue();
            }
        };
        return stats;
    }

    protected NumberAnalyzerResult buildResult(Crosstab<?> crosstab, Collection<? extends NumberAnalyzerResult> results) {
        NumberAnalyzerResult firstResult = results.iterator().next();
        InputColumn<? extends Number>[] columns = firstResult.getColumns();
        return new NumberAnalyzerResult(columns, crosstab);
    }
}

