/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.analyzer.beans;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.eobjects.analyzer.beans.StringAnalyzerColumnDelegate;
import org.eobjects.analyzer.beans.StringAnalyzerResult;
import org.eobjects.analyzer.beans.api.Analyzer;
import org.eobjects.analyzer.beans.api.AnalyzerBean;
import org.eobjects.analyzer.beans.api.Concurrent;
import org.eobjects.analyzer.beans.api.Configured;
import org.eobjects.analyzer.beans.api.Description;
import org.eobjects.analyzer.beans.api.Initialize;
import org.eobjects.analyzer.beans.api.Provided;
import org.eobjects.analyzer.data.InputColumn;
import org.eobjects.analyzer.data.InputRow;
import org.eobjects.analyzer.result.AnalyzerResult;
import org.eobjects.analyzer.result.AnnotatedRowsResult;
import org.eobjects.analyzer.result.Crosstab;
import org.eobjects.analyzer.result.CrosstabDimension;
import org.eobjects.analyzer.result.CrosstabNavigator;
import org.eobjects.analyzer.storage.InMemoryRowAnnotationFactory;
import org.eobjects.analyzer.storage.RowAnnotation;
import org.eobjects.analyzer.storage.RowAnnotationFactory;
import org.eobjects.analyzer.util.AverageBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AnalyzerBean(value="String analyzer")
@Description(value="The String analyzer is used to collect a variety of typical metrics on string values.\nMetrics include statistics on character case, words, diacritics, white-spaces and more...")
@Concurrent(value=true)
public class StringAnalyzer
implements Analyzer<StringAnalyzerResult> {
    public static final String DIMENSION_MEASURES = "Measures";
    public static final String DIMENSION_COLUMN = "Column";
    public static final String MEASURE_MIN_WORDS = "Min words";
    public static final String MEASURE_MAX_WORDS = "Max words";
    public static final String MEASURE_WORD_COUNT = "Word count";
    public static final String MEASURE_NON_LETTER_CHARS = "Non-letter chars";
    public static final String MEASURE_DIACRITIC_CHARS = "Diacritic chars";
    public static final String MEASURE_DIGIT_CHARS = "Digit chars";
    public static final String MEASURE_LOWERCASE_CHARS = "Lowercase chars";
    public static final String MEASURE_UPPERCASE_CHARS_EXCL_FIRST_LETTERS = "Uppercase chars (excl. first letters)";
    public static final String MEASURE_UPPERCASE_CHARS = "Uppercase chars";
    public static final String MEASURE_AVG_WHITE_SPACES = "Avg white spaces";
    public static final String MEASURE_MIN_WHITE_SPACES = "Min white spaces";
    public static final String MEASURE_MAX_WHITE_SPACES = "Max white spaces";
    public static final String MEASURE_AVG_CHARS = "Avg chars";
    public static final String MEASURE_MIN_CHARS = "Min chars";
    public static final String MEASURE_MAX_CHARS = "Max chars";
    public static final String MEASURE_TOTAL_CHAR_COUNT = "Total char count";
    public static final String MEASURE_ENTIRELY_LOWERCASE_COUNT = "Entirely lowercase count";
    public static final String MEASURE_ENTIRELY_UPPERCASE_COUNT = "Entirely uppercase count";
    public static final String MEASURE_BLANK_COUNT = "Blank count";
    public static final String MEASURE_NULL_COUNT = "Null count";
    public static final String MEASURE_ROW_COUNT = "Row count";
    private static final Logger logger = LoggerFactory.getLogger(StringAnalyzer.class);
    private final Map<InputColumn<String>, StringAnalyzerColumnDelegate> _columnDelegates = new HashMap<InputColumn<String>, StringAnalyzerColumnDelegate>();
    @Configured
    InputColumn<String>[] _columns;
    @Provided
    RowAnnotationFactory _annotationFactory;

    public StringAnalyzer() {
    }

    public StringAnalyzer(InputColumn<String> ... columns) {
        this._columns = columns;
        this._annotationFactory = new InMemoryRowAnnotationFactory();
        this.init();
    }

    @Initialize
    public void init() {
        for (InputColumn<String> column : this._columns) {
            this._columnDelegates.put(column, new StringAnalyzerColumnDelegate(this._annotationFactory));
        }
    }

    public void run(InputRow row, int distinctCount) {
        for (InputColumn<String> column : this._columns) {
            String value = (String)row.getValue(column);
            StringAnalyzerColumnDelegate delegate = this._columnDelegates.get(column);
            delegate.run(row, value, distinctCount);
        }
    }

    public StringAnalyzerResult getResult() {
        logger.info("getResult()");
        CrosstabDimension measureDimension = new CrosstabDimension(DIMENSION_MEASURES);
        measureDimension.addCategory(MEASURE_ROW_COUNT);
        measureDimension.addCategory(MEASURE_NULL_COUNT);
        measureDimension.addCategory(MEASURE_BLANK_COUNT);
        measureDimension.addCategory(MEASURE_ENTIRELY_UPPERCASE_COUNT);
        measureDimension.addCategory(MEASURE_ENTIRELY_LOWERCASE_COUNT);
        measureDimension.addCategory(MEASURE_TOTAL_CHAR_COUNT);
        measureDimension.addCategory(MEASURE_MAX_CHARS);
        measureDimension.addCategory(MEASURE_MIN_CHARS);
        measureDimension.addCategory(MEASURE_AVG_CHARS);
        measureDimension.addCategory(MEASURE_MAX_WHITE_SPACES);
        measureDimension.addCategory(MEASURE_MIN_WHITE_SPACES);
        measureDimension.addCategory(MEASURE_AVG_WHITE_SPACES);
        measureDimension.addCategory(MEASURE_UPPERCASE_CHARS);
        measureDimension.addCategory(MEASURE_UPPERCASE_CHARS_EXCL_FIRST_LETTERS);
        measureDimension.addCategory(MEASURE_LOWERCASE_CHARS);
        measureDimension.addCategory(MEASURE_DIGIT_CHARS);
        measureDimension.addCategory(MEASURE_DIACRITIC_CHARS);
        measureDimension.addCategory(MEASURE_NON_LETTER_CHARS);
        measureDimension.addCategory(MEASURE_WORD_COUNT);
        measureDimension.addCategory(MEASURE_MAX_WORDS);
        measureDimension.addCategory(MEASURE_MIN_WORDS);
        CrosstabDimension columnDimension = new CrosstabDimension(DIMENSION_COLUMN);
        Crosstab crosstab = new Crosstab(Number.class, new CrosstabDimension[]{columnDimension, measureDimension});
        for (InputColumn<String> column : this._columns) {
            String columnName = column.getName();
            StringAnalyzerColumnDelegate delegate = this._columnDelegates.get(column);
            columnDimension.addCategory(columnName);
            Integer numRows = delegate.getNumRows();
            Integer numNull = delegate.getNumNull();
            Integer numBlank = delegate.getNumBlank();
            Integer numEntirelyUppercase = delegate.getNumEntirelyUppercase();
            Integer numEntirelyLowercase = delegate.getNumEntirelyLowercase();
            Integer numChars = delegate.getNumChars();
            Integer maxChars = delegate.getMaxChars();
            Integer minChars = delegate.getMinChars();
            Integer numWords = delegate.getNumWords();
            Integer maxWords = delegate.getMaxWords();
            Integer minWords = delegate.getMinWords();
            Integer maxWhitespace = delegate.getMaxWhitespace();
            Integer minWhitespace = delegate.getMinWhitespace();
            Integer numUppercase = delegate.getNumUppercase();
            Integer numUppercaseExclFirstLetter = delegate.getNumUppercaseExclFirstLetter();
            Integer numLowercase = delegate.getNumLowercase();
            Integer numDigits = delegate.getNumDigit();
            Integer numDiacritics = delegate.getNumDiacritics();
            Integer numNonLetter = delegate.getNumNonLetter();
            AverageBuilder charAverageBuilder = delegate.getCharAverageBuilder();
            AverageBuilder blanksAverageBuilder = delegate.getWhitespaceAverageBuilder();
            Double avgChars = null;
            if (charAverageBuilder.getNumValues() > 0) {
                avgChars = charAverageBuilder.getAverage();
            }
            Double avgBlanks = null;
            if (blanksAverageBuilder.getNumValues() > 0) {
                avgBlanks = blanksAverageBuilder.getAverage();
            }
            CrosstabNavigator nav = crosstab.where(columnDimension, columnName);
            nav.where(measureDimension, MEASURE_ROW_COUNT).put((Serializable)numRows);
            nav.where(measureDimension, MEASURE_NULL_COUNT).put((Serializable)numNull);
            if (numNull > 0) {
                this.addAttachment((CrosstabNavigator<Number>)nav, delegate.getNullAnnotation(), column);
            }
            nav.where(measureDimension, MEASURE_BLANK_COUNT).put((Serializable)numBlank);
            if (numBlank > 0) {
                this.addAttachment((CrosstabNavigator<Number>)nav, delegate.getBlankAnnotation(), column);
            }
            nav.where(measureDimension, MEASURE_ENTIRELY_UPPERCASE_COUNT).put((Serializable)numEntirelyUppercase);
            if (numEntirelyUppercase > 0) {
                this.addAttachment((CrosstabNavigator<Number>)nav, delegate.getEntirelyUppercaseAnnotation(), column);
            }
            nav.where(measureDimension, MEASURE_ENTIRELY_LOWERCASE_COUNT).put((Serializable)numEntirelyLowercase);
            if (numEntirelyLowercase > 0) {
                this.addAttachment((CrosstabNavigator<Number>)nav, delegate.getEntirelyLowercaseAnnotation(), column);
            }
            nav.where(measureDimension, MEASURE_TOTAL_CHAR_COUNT).put((Serializable)numChars);
            nav.where(measureDimension, MEASURE_MAX_CHARS).put((Serializable)maxChars);
            if (maxChars != null) {
                this.addAttachment((CrosstabNavigator<Number>)nav, delegate.getMaxCharsAnnotation(), column);
            }
            nav.where(measureDimension, MEASURE_MIN_CHARS).put((Serializable)minChars);
            if (minChars != null) {
                this.addAttachment((CrosstabNavigator<Number>)nav, delegate.getMinCharsAnnotation(), column);
            }
            nav.where(measureDimension, MEASURE_AVG_CHARS).put((Serializable)avgChars);
            nav.where(measureDimension, MEASURE_MAX_WHITE_SPACES).put((Serializable)maxWhitespace);
            if (maxWhitespace != null) {
                this.addAttachment((CrosstabNavigator<Number>)nav, delegate.getMaxWhitespaceAnnotation(), column);
            }
            nav.where(measureDimension, MEASURE_MIN_WHITE_SPACES).put((Serializable)minWhitespace);
            if (minWhitespace != null) {
                this.addAttachment((CrosstabNavigator<Number>)nav, delegate.getMinWhitespaceAnnotation(), column);
            }
            nav.where(measureDimension, MEASURE_AVG_WHITE_SPACES).put((Serializable)avgBlanks);
            nav.where(measureDimension, MEASURE_UPPERCASE_CHARS).put((Serializable)numUppercase);
            nav.where(measureDimension, MEASURE_UPPERCASE_CHARS_EXCL_FIRST_LETTERS).put((Serializable)numUppercaseExclFirstLetter);
            if (numUppercaseExclFirstLetter > 0) {
                this.addAttachment((CrosstabNavigator<Number>)nav, delegate.getUppercaseExclFirstLetterAnnotation(), column);
            }
            nav.where(measureDimension, MEASURE_LOWERCASE_CHARS).put((Serializable)numLowercase);
            nav.where(measureDimension, MEASURE_DIGIT_CHARS).put((Serializable)numDigits);
            if (numDigits > 0) {
                this.addAttachment((CrosstabNavigator<Number>)nav, delegate.getDigitAnnotation(), column);
            }
            nav.where(measureDimension, MEASURE_DIACRITIC_CHARS).put((Serializable)numDiacritics);
            if (numDiacritics > 0) {
                this.addAttachment((CrosstabNavigator<Number>)nav, delegate.getDiacriticAnnotation(), column);
            }
            nav.where(measureDimension, MEASURE_NON_LETTER_CHARS).put((Serializable)numNonLetter);
            nav.where(measureDimension, MEASURE_WORD_COUNT).put((Serializable)numWords);
            nav.where(measureDimension, MEASURE_MAX_WORDS).put((Serializable)maxWords);
            if (maxWords != null) {
                this.addAttachment((CrosstabNavigator<Number>)nav, delegate.getMaxWordsAnnotation(), column);
            }
            nav.where(measureDimension, MEASURE_MIN_WORDS).put((Serializable)minWords);
            if (minWords == null) continue;
            this.addAttachment((CrosstabNavigator<Number>)nav, delegate.getMinWordsAnnotation(), column);
        }
        return new StringAnalyzerResult(this._columns, crosstab);
    }

    private void addAttachment(CrosstabNavigator<Number> nav, RowAnnotation annotation, InputColumn<?> column) {
        nav.attach((AnalyzerResult)new AnnotatedRowsResult(annotation, this._annotationFactory, new InputColumn[]{column}));
    }
}

