/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.analyzer.beans;

import java.util.StringTokenizer;
import org.eobjects.analyzer.data.InputRow;
import org.eobjects.analyzer.storage.RowAnnotation;
import org.eobjects.analyzer.storage.RowAnnotationFactory;
import org.eobjects.analyzer.util.AverageBuilder;
import org.eobjects.analyzer.util.CharIterator;

final class StringAnalyzerColumnDelegate {
    private final RowAnnotationFactory _annotationFactory;
    private final AverageBuilder _charAverageBuilder = new AverageBuilder();
    private final AverageBuilder _whitespaceAverageBuilder = new AverageBuilder();
    private final RowAnnotation _nullAnnotation;
    private final RowAnnotation _blankAnnotation;
    private final RowAnnotation _entirelyUppercaseAnnotation;
    private final RowAnnotation _entirelyLowercaseAnnotation;
    private final RowAnnotation _maxCharsAnnotation;
    private final RowAnnotation _minCharsAnnotation;
    private final RowAnnotation _maxWhitespaceAnnotation;
    private final RowAnnotation _minWhitespaceAnnotation;
    private final RowAnnotation _uppercaseExclFirstLetterAnnotation;
    private final RowAnnotation _digitAnnotation;
    private final RowAnnotation _diacriticAnnotation;
    private final RowAnnotation _maxWordsAnnotation;
    private final RowAnnotation _minWordsAnnotation;
    private volatile int _numRows;
    private volatile int _numEntirelyUppercase;
    private volatile int _numEntirelyLowercase;
    private volatile int _numChars;
    private volatile Integer _minChars;
    private volatile Integer _maxChars;
    private volatile Integer _minWhitespace;
    private volatile Integer _maxWhitespace;
    private volatile int _numUppercase;
    private volatile int _numUppercaseExclFirstLetter;
    private volatile int _numLowercase;
    private volatile int _numDigit;
    private volatile int _numDiacritics;
    private volatile int _numNonLetter;
    private volatile int _numWords;
    private volatile Integer _maxWords;
    private volatile Integer _minWords;

    public StringAnalyzerColumnDelegate(RowAnnotationFactory annotationFactory) {
        this._annotationFactory = annotationFactory;
        this._nullAnnotation = annotationFactory.createAnnotation();
        this._blankAnnotation = annotationFactory.createAnnotation();
        this._entirelyUppercaseAnnotation = annotationFactory.createAnnotation();
        this._entirelyLowercaseAnnotation = annotationFactory.createAnnotation();
        this._maxCharsAnnotation = annotationFactory.createAnnotation();
        this._minCharsAnnotation = annotationFactory.createAnnotation();
        this._maxWhitespaceAnnotation = annotationFactory.createAnnotation();
        this._minWhitespaceAnnotation = annotationFactory.createAnnotation();
        this._uppercaseExclFirstLetterAnnotation = annotationFactory.createAnnotation();
        this._digitAnnotation = annotationFactory.createAnnotation();
        this._diacriticAnnotation = annotationFactory.createAnnotation();
        this._maxWordsAnnotation = annotationFactory.createAnnotation();
        this._minWordsAnnotation = annotationFactory.createAnnotation();
    }

    public synchronized void run(InputRow row, String value, int distinctCount) {
        this._numRows += distinctCount;
        if (value == null) {
            this._annotationFactory.annotate(row, distinctCount, this._nullAnnotation);
        } else {
            int numChars = value.length();
            if (numChars == 0) {
                this._annotationFactory.annotate(row, distinctCount, this._blankAnnotation);
            }
            int totalChars = numChars * distinctCount;
            int numWords = new StringTokenizer(value).countTokens();
            int totalWords = numWords * distinctCount;
            int numWhitespace = 0;
            int numDigits = 0;
            int numDiacritics = 0;
            int numLetters = 0;
            int numNonLetters = 0;
            int numUppercase = 0;
            int numUppercaseExclFirstLetter = 0;
            int numLowercase = 0;
            boolean firstLetter = true;
            CharIterator it = new CharIterator((CharSequence)value);
            while (it.hasNext()) {
                it.next();
                if (it.isLetter()) {
                    numLetters += distinctCount;
                    if (it.isUpperCase()) {
                        numUppercase += distinctCount;
                        if (!firstLetter) {
                            numUppercaseExclFirstLetter += distinctCount;
                        }
                    } else {
                        numLowercase += distinctCount;
                    }
                    if (it.isDiacritic()) {
                        numDiacritics += distinctCount;
                    }
                    firstLetter = false;
                    continue;
                }
                numNonLetters += distinctCount;
                if (it.isDigit()) {
                    numDigits += distinctCount;
                }
                if (it.isWhitespace()) {
                    ++numWhitespace;
                }
                if (!it.is(Character.valueOf('.'))) continue;
                firstLetter = true;
            }
            this._numUppercase += numUppercase;
            if (numUppercaseExclFirstLetter > 0) {
                this._annotationFactory.annotate(row, distinctCount, this._uppercaseExclFirstLetterAnnotation);
                this._numUppercaseExclFirstLetter += numUppercaseExclFirstLetter;
            }
            this._numLowercase += numLowercase;
            this._numNonLetter += numNonLetters;
            if (this._minChars == null) {
                this._minChars = numChars;
                this._maxChars = numChars;
                this._minWords = numWords;
                this._maxWords = numWords;
                this._minWhitespace = numWhitespace;
                this._maxWhitespace = numWhitespace;
            }
            this._numChars += totalChars;
            this._numWords += totalWords;
            if (numDiacritics > 0) {
                this._numDiacritics += numDiacritics;
                this._annotationFactory.annotate(row, distinctCount, this._diacriticAnnotation);
            }
            if (numDigits > 0) {
                this._numDigit += numDigits;
                this._annotationFactory.annotate(row, distinctCount, this._digitAnnotation);
            }
            if (this._maxChars < numChars) {
                this._annotationFactory.reset(this._maxCharsAnnotation);
                this._maxChars = numChars;
            }
            if (this._maxChars == numChars) {
                this._annotationFactory.annotate(row, distinctCount, this._maxCharsAnnotation);
            }
            if (this._minChars > numChars) {
                this._annotationFactory.reset(this._minCharsAnnotation);
                this._minChars = numChars;
            }
            if (this._minChars == numChars) {
                this._annotationFactory.annotate(row, distinctCount, this._minCharsAnnotation);
            }
            if (this._maxWords < numWords) {
                this._maxWords = numWords;
                this._annotationFactory.reset(this._maxWordsAnnotation);
            }
            if (this._maxWords == numWords) {
                this._annotationFactory.annotate(row, distinctCount, this._maxWordsAnnotation);
            }
            if (this._minWords > numWords) {
                this._minWords = numWords;
                this._annotationFactory.reset(this._minWordsAnnotation);
            }
            if (this._minWords == numWords) {
                this._annotationFactory.annotate(row, distinctCount, this._minWordsAnnotation);
            }
            if (this._maxWhitespace < numWhitespace) {
                this._maxWhitespace = numWhitespace;
                this._annotationFactory.reset(this._maxWhitespaceAnnotation);
            }
            if (this._maxWhitespace == numWhitespace) {
                this._annotationFactory.annotate(row, distinctCount, this._maxWhitespaceAnnotation);
            }
            if (this._minWhitespace > numWhitespace) {
                this._minWhitespace = numWhitespace;
                this._annotationFactory.reset(this._minWhitespaceAnnotation);
            }
            if (this._minWhitespace == numWhitespace) {
                this._annotationFactory.annotate(row, distinctCount, this._minWhitespaceAnnotation);
            }
            if (numLetters > 0) {
                if (StringAnalyzerColumnDelegate.isEntirelyUpperCase(value)) {
                    this._numEntirelyUppercase += distinctCount;
                    this._annotationFactory.annotate(row, distinctCount, this._entirelyUppercaseAnnotation);
                }
                if (StringAnalyzerColumnDelegate.isEntirelyLowerCase(value)) {
                    this._numEntirelyLowercase += distinctCount;
                    this._annotationFactory.annotate(row, distinctCount, this._entirelyLowercaseAnnotation);
                }
            }
            this._charAverageBuilder.addValue((Number)numChars);
            this._whitespaceAverageBuilder.addValue((Number)numWhitespace);
        }
    }

    protected static boolean isEntirelyLowerCase(String value) {
        return value.equals(value.toLowerCase());
    }

    protected static boolean isEntirelyUpperCase(String value) {
        return value.equals(value.toUpperCase());
    }

    public int getNumRows() {
        return this._numRows;
    }

    public int getNumNull() {
        return this._nullAnnotation.getRowCount();
    }

    public int getNumEntirelyUppercase() {
        return this._numEntirelyUppercase;
    }

    public int getNumEntirelyLowercase() {
        return this._numEntirelyLowercase;
    }

    public int getNumChars() {
        return this._numChars;
    }

    public Integer getMinChars() {
        return this._minChars;
    }

    public Integer getMaxChars() {
        return this._maxChars;
    }

    public Integer getMinWhitespace() {
        return this._minWhitespace;
    }

    public Integer getMaxWhitespace() {
        return this._maxWhitespace;
    }

    public int getNumUppercase() {
        return this._numUppercase;
    }

    public int getNumUppercaseExclFirstLetter() {
        return this._numUppercaseExclFirstLetter;
    }

    public int getNumLowercase() {
        return this._numLowercase;
    }

    public int getNumDigit() {
        return this._numDigit;
    }

    public int getNumDiacritics() {
        return this._numDiacritics;
    }

    public int getNumNonLetter() {
        return this._numNonLetter;
    }

    public int getNumWords() {
        return this._numWords;
    }

    public Integer getMinWords() {
        return this._minWords;
    }

    public Integer getMaxWords() {
        return this._maxWords;
    }

    public AverageBuilder getCharAverageBuilder() {
        return this._charAverageBuilder;
    }

    public AverageBuilder getWhitespaceAverageBuilder() {
        return this._whitespaceAverageBuilder;
    }

    public RowAnnotation getNullAnnotation() {
        return this._nullAnnotation;
    }

    public RowAnnotation getBlankAnnotation() {
        return this._blankAnnotation;
    }

    public RowAnnotation getEntirelyUppercaseAnnotation() {
        return this._entirelyUppercaseAnnotation;
    }

    public RowAnnotation getEntirelyLowercaseAnnotation() {
        return this._entirelyLowercaseAnnotation;
    }

    public RowAnnotation getMaxCharsAnnotation() {
        return this._maxCharsAnnotation;
    }

    public RowAnnotation getMinCharsAnnotation() {
        return this._minCharsAnnotation;
    }

    public RowAnnotation getMaxWhitespaceAnnotation() {
        return this._maxWhitespaceAnnotation;
    }

    public RowAnnotation getMinWhitespaceAnnotation() {
        return this._minWhitespaceAnnotation;
    }

    public RowAnnotation getUppercaseExclFirstLetterAnnotation() {
        return this._uppercaseExclFirstLetterAnnotation;
    }

    public RowAnnotation getDigitAnnotation() {
        return this._digitAnnotation;
    }

    public RowAnnotation getDiacriticAnnotation() {
        return this._diacriticAnnotation;
    }

    public RowAnnotation getMaxWordsAnnotation() {
        return this._maxWordsAnnotation;
    }

    public RowAnnotation getMinWordsAnnotation() {
        return this._minWordsAnnotation;
    }

    public Integer getNumBlank() {
        return this._blankAnnotation.getRowCount();
    }
}

