/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.analyzer.beans;

import org.eobjects.analyzer.beans.StringAnalyzerResultReducer;
import org.eobjects.analyzer.beans.api.Distributed;
import org.eobjects.analyzer.data.InputColumn;
import org.eobjects.analyzer.result.Crosstab;
import org.eobjects.analyzer.result.CrosstabResult;
import org.eobjects.analyzer.result.Metric;

@Distributed(reducer=StringAnalyzerResultReducer.class)
public class StringAnalyzerResult
extends CrosstabResult {
    private static final long serialVersionUID = 1L;
    private final InputColumn<String>[] _columns;

    public StringAnalyzerResult(InputColumn<String>[] columns, Crosstab<?> crosstab) {
        super(crosstab);
        this._columns = columns;
    }

    public InputColumn<String>[] getColumns() {
        return this._columns;
    }

    @Metric(value="Avg chars")
    public double getAvgChars(InputColumn<?> col) {
        return (Double)this.getCrosstab().where("Column", col.getName()).where("Measures", "Avg chars").get();
    }

    @Metric(value="Avg white spaces")
    public double getAvgWhitespaces(InputColumn<?> col) {
        return (Double)this.getCrosstab().where("Column", col.getName()).where("Measures", "Avg white spaces").get();
    }

    @Metric(value="Diacritic chars")
    public int getDiacritiChars(InputColumn<?> col) {
        return (Integer)this.getCrosstab().where("Column", col.getName()).where("Measures", "Diacritic chars").get();
    }

    @Metric(value="Digit chars")
    public int getDigitChars(InputColumn<?> col) {
        return (Integer)this.getCrosstab().where("Column", col.getName()).where("Measures", "Digit chars").get();
    }

    @Metric(value="Entirely lowercase count")
    public int getEntirelyLowerCaseCount(InputColumn<?> col) {
        return (Integer)this.getCrosstab().where("Column", col.getName()).where("Measures", "Entirely lowercase count").get();
    }

    @Metric(value="Entirely uppercase count")
    public int getEntirelyUpperCaseCount(InputColumn<?> col) {
        return (Integer)this.getCrosstab().where("Column", col.getName()).where("Measures", "Entirely uppercase count").get();
    }

    @Metric(value="Lowercase chars")
    public int getLowerCaseChars(InputColumn<?> col) {
        return (Integer)this.getCrosstab().where("Column", col.getName()).where("Measures", "Lowercase chars").get();
    }

    @Metric(value="Max chars")
    public int getMaxChars(InputColumn<?> col) {
        return (Integer)this.getCrosstab().where("Column", col.getName()).where("Measures", "Max chars").get();
    }

    @Metric(value="Max white spaces")
    public int getMaxWhitespaces(InputColumn<?> col) {
        return (Integer)this.getCrosstab().where("Column", col.getName()).where("Measures", "Max white spaces").get();
    }

    @Metric(value="Max words")
    public int getMaxWords(InputColumn<?> col) {
        return (Integer)this.getCrosstab().where("Column", col.getName()).where("Measures", "Max words").get();
    }

    @Metric(value="Min chars")
    public int getMinChars(InputColumn<?> col) {
        return (Integer)this.getCrosstab().where("Column", col.getName()).where("Measures", "Min chars").get();
    }

    @Metric(value="Min white spaces")
    public int getMinWhitespaces(InputColumn<?> col) {
        return (Integer)this.getCrosstab().where("Column", col.getName()).where("Measures", "Min white spaces").get();
    }

    @Metric(value="Min words")
    public int getMinWords(InputColumn<?> col) {
        return (Integer)this.getCrosstab().where("Column", col.getName()).where("Measures", "Min words").get();
    }

    @Metric(value="Non-letter chars")
    public int getNonLetterChars(InputColumn<?> col) {
        return (Integer)this.getCrosstab().where("Column", col.getName()).where("Measures", "Non-letter chars").get();
    }

    @Metric(value="Null count")
    public int getNullCount(InputColumn<?> col) {
        return (Integer)this.getCrosstab().where("Column", col.getName()).where("Measures", "Null count").get();
    }

    @Metric(value="Blank count")
    public Integer getBlankCount(InputColumn<?> col) {
        return (Integer)this.getCrosstab().where("Column", col.getName()).where("Measures", "Blank count").safeGet(null);
    }

    @Metric(value="Row count")
    public int getRowCount(InputColumn<?> col) {
        return (Integer)this.getCrosstab().where("Column", col.getName()).where("Measures", "Row count").get();
    }

    @Metric(value="Total char count")
    public int getTotalCharCount(InputColumn<?> col) {
        return (Integer)this.getCrosstab().where("Column", col.getName()).where("Measures", "Total char count").get();
    }

    @Metric(value="Uppercase chars")
    public int getUpperCaseChars(InputColumn<?> col) {
        return (Integer)this.getCrosstab().where("Column", col.getName()).where("Measures", "Uppercase chars").get();
    }

    @Metric(value="Uppercase chars (excl. first letters)")
    public int getUpperCaseCharsExcludingFirstLetters(InputColumn<?> col) {
        return (Integer)this.getCrosstab().where("Column", col.getName()).where("Measures", "Uppercase chars (excl. first letters)").get();
    }

    @Metric(value="Word count")
    public int getWordCount(InputColumn<?> col) {
        return (Integer)this.getCrosstab().where("Column", col.getName()).where("Measures", "Word count").get();
    }
}

