/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.analyzer.beans;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eobjects.analyzer.beans.StringAnalyzerResult;
import org.eobjects.analyzer.data.InputColumn;
import org.eobjects.analyzer.result.AbstractCrosstabResultReducer;
import org.eobjects.analyzer.result.Crosstab;
import org.eobjects.analyzer.result.CrosstabNavigator;
import org.eobjects.analyzer.util.AverageBuilder;

public class StringAnalyzerResultReducer
extends AbstractCrosstabResultReducer<StringAnalyzerResult> {
    private static final Set<String> AVG_MEASURES = new HashSet<String>(Arrays.asList("Avg chars", "Avg white spaces"));
    private static final Set<String> MIN_MEASURES = new HashSet<String>(Arrays.asList("Min chars", "Min white spaces", "Min words"));
    private static final Set<String> MAX_MEASURES = new HashSet<String>(Arrays.asList("Max chars", "Max white spaces", "Max words"));

    protected Serializable reduceValues(List<Object> slaveValues, String category1, String category2, Collection<? extends StringAnalyzerResult> results, Class<?> valueClass) {
        if (AVG_MEASURES.contains(category2)) {
            return this.weightedAverage(slaveValues, results, category1, category2);
        }
        if (MIN_MEASURES.contains(category2)) {
            return StringAnalyzerResultReducer.minimum(slaveValues);
        }
        if (MAX_MEASURES.contains(category2)) {
            return StringAnalyzerResultReducer.maximum(slaveValues);
        }
        return StringAnalyzerResultReducer.sumAsInteger(slaveValues);
    }

    private Serializable weightedAverage(List<Object> slaveValues, Collection<? extends StringAnalyzerResult> results, String columnName, String measureName) {
        AverageBuilder averageBuilder = new AverageBuilder();
        for (StringAnalyzerResult stringAnalyzerResult : results) {
            Crosstab crosstab = stringAnalyzerResult.getCrosstab();
            CrosstabNavigator nav = crosstab.where("Column", columnName);
            Number rowCount = (Number)nav.where("Measures", "Row count").get();
            Number averageMeasureValue = (Number)nav.where("Measures", measureName).get();
            averageBuilder.addValue(averageMeasureValue, rowCount.intValue());
        }
        return Double.valueOf(averageBuilder.getAverage());
    }

    protected StringAnalyzerResult buildResult(Crosstab<?> crosstab, Collection<? extends StringAnalyzerResult> results) {
        StringAnalyzerResult firstResult = results.iterator().next();
        InputColumn<String>[] columns = firstResult.getColumns();
        return new StringAnalyzerResult(columns, crosstab);
    }
}

