/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.analyzer.util;

import java.util.Arrays;
import java.util.List;
import org.eobjects.metamodel.util.BaseObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValueCombination<E>
extends BaseObject
implements Comparable<ValueCombination<E>> {
    private static final Logger logger = LoggerFactory.getLogger(ValueCombination.class);
    private final E[] _values;

    public ValueCombination(E ... values) {
        this._values = values;
    }

    protected void decorateIdentity(List<Object> identifiers) {
        identifiers.add(this._values);
    }

    public int getValueCount() {
        return this._values.length;
    }

    public E getValueAt(int index) {
        return this._values[index];
    }

    public String toString() {
        return "ValueCombination[" + Arrays.toString(this._values) + "]";
    }

    @Override
    public int compareTo(ValueCombination<E> o) {
        if (this.equals(o)) {
            return 0;
        }
        int count1 = this.getValueCount();
        int count2 = o.getValueCount();
        int minCount = Math.min(count1, count2);
        for (int i = 0; i < minCount; ++i) {
            E value1 = this.getValueAt(i);
            E value2 = o.getValueAt(i);
            if (value1 == null || value2 == null) {
                if (value1 != null) {
                    return -1;
                }
                if (value2 == null) continue;
                return 1;
            }
            if (value1 instanceof Comparable) {
                try {
                    int result = ((Comparable)value1).compareTo(value2);
                    if (result != 0) {
                        return result;
                    }
                }
                catch (Exception e) {
                    logger.warn("Could not compare {} and {}, comparable threw exception: {}", new Object[]{value1, value2, e.getMessage()});
                    logger.debug("Comparable threw exception", (Throwable)e);
                }
                continue;
            }
            logger.warn("Could not compare {} and {}, not comparable", value1, value2);
        }
        int result = count1 - count2;
        if (result == 0) {
            result = -1;
        }
        return result;
    }
}

