/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.analyzer.beans.coalesce;

import java.util.Date;
import org.eobjects.analyzer.beans.api.Categorized;
import org.eobjects.analyzer.beans.api.Configured;
import org.eobjects.analyzer.beans.api.Description;
import org.eobjects.analyzer.beans.api.OutputColumns;
import org.eobjects.analyzer.beans.api.Transformer;
import org.eobjects.analyzer.beans.api.TransformerBean;
import org.eobjects.analyzer.beans.categories.DateAndTimeCategory;
import org.eobjects.analyzer.data.InputColumn;
import org.eobjects.analyzer.data.InputRow;

@TransformerBean(value="Coalesce dates")
@Description(value="Returns the first non-null date out of a set of dates. Use it to identify relative dates such as 'latest activity' date if multiple stages in a process may have been recorded in different columns.")
@Categorized(value={DateAndTimeCategory.class})
public class CoalesceDatesTransformer
implements Transformer<Date> {
    @Configured
    InputColumn<Date>[] input;

    public CoalesceDatesTransformer() {
    }

    public CoalesceDatesTransformer(InputColumn<Date> ... input) {
        this();
        this.input = input;
    }

    public OutputColumns getOutputColumns() {
        return new OutputColumns("Coalesced date", new String[0]);
    }

    public Date[] transform(InputRow inputRow) {
        for (InputColumn<Date> column : this.input) {
            Date value = (Date)inputRow.getValue(column);
            if (value == null) continue;
            return new Date[]{value};
        }
        return new Date[1];
    }
}

