/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.analyzer.beans.coalesce;

import org.eobjects.analyzer.beans.api.Categorized;
import org.eobjects.analyzer.beans.api.Configured;
import org.eobjects.analyzer.beans.api.Description;
import org.eobjects.analyzer.beans.api.OutputColumns;
import org.eobjects.analyzer.beans.api.Transformer;
import org.eobjects.analyzer.beans.api.TransformerBean;
import org.eobjects.analyzer.beans.categories.NumbersCategory;
import org.eobjects.analyzer.data.InputColumn;
import org.eobjects.analyzer.data.InputRow;

@TransformerBean(value="Coalesce numbers")
@Description(value="Returns the first non-null number. Use it to identify the most accurate or most recent number if multiple observations have been recorded in columns.")
@Categorized(value={NumbersCategory.class})
public class CoalesceNumbersTransformer
implements Transformer<Number> {
    @Configured
    InputColumn<Number>[] input;

    public CoalesceNumbersTransformer() {
    }

    public CoalesceNumbersTransformer(InputColumn<Number> ... input) {
        this();
        this.input = input;
    }

    public OutputColumns getOutputColumns() {
        return new OutputColumns("Coalesced number", new String[0]);
    }

    public Number[] transform(InputRow inputRow) {
        for (InputColumn<Number> column : this.input) {
            Number value = (Number)inputRow.getValue(column);
            if (value == null) continue;
            return new Number[]{value};
        }
        return new Number[1];
    }
}

