/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.analyzer.beans.coalesce;

import org.eobjects.analyzer.beans.api.Categorized;
import org.eobjects.analyzer.beans.api.Configured;
import org.eobjects.analyzer.beans.api.Description;
import org.eobjects.analyzer.beans.api.OutputColumns;
import org.eobjects.analyzer.beans.api.Transformer;
import org.eobjects.analyzer.beans.api.TransformerBean;
import org.eobjects.analyzer.beans.categories.StringManipulationCategory;
import org.eobjects.analyzer.data.InputColumn;
import org.eobjects.analyzer.data.InputRow;

@TransformerBean(value="Coalesce strings")
@Description(value="Returns the first non-null string. Use it to identify the most accurate or most recent observation, if multiple entries have been recorded in separate columns.")
@Categorized(value={StringManipulationCategory.class})
public class CoalesceStringsTransformer
implements Transformer<String> {
    @Configured
    InputColumn<String>[] input;
    @Configured
    @Description(value="Consider empty strings (\"\") as null also?")
    boolean considerEmptyStringAsNull = true;

    public CoalesceStringsTransformer() {
    }

    public CoalesceStringsTransformer(InputColumn<String> ... input) {
        this();
        this.input = input;
    }

    public OutputColumns getOutputColumns() {
        return new OutputColumns("Coalesced string", new String[0]);
    }

    public String[] transform(InputRow inputRow) {
        for (InputColumn<String> column : this.input) {
            String value = (String)inputRow.getValue(column);
            if (value == null) continue;
            if (this.considerEmptyStringAsNull) {
                if ("".equals(value)) continue;
                return new String[]{value};
            }
            return new String[]{value};
        }
        return new String[1];
    }
}

