/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.analyzer.beans.numbers;

import java.util.concurrent.atomic.AtomicInteger;
import org.eobjects.analyzer.beans.api.Categorized;
import org.eobjects.analyzer.beans.api.Configured;
import org.eobjects.analyzer.beans.api.Description;
import org.eobjects.analyzer.beans.api.Initialize;
import org.eobjects.analyzer.beans.api.OutputColumns;
import org.eobjects.analyzer.beans.api.Transformer;
import org.eobjects.analyzer.beans.api.TransformerBean;
import org.eobjects.analyzer.beans.categories.NumbersCategory;
import org.eobjects.analyzer.data.InputColumn;
import org.eobjects.analyzer.data.InputRow;

@TransformerBean(value="Generate ID")
@Description(value="Generates a unique and sequential record ID")
@Categorized(value={NumbersCategory.class})
public class GenerateIdTransformer
implements Transformer<Integer> {
    @Configured
    @Description(value="A column which represent the scope for which the ID will be generated. If eg. a source column is selected, an ID will be generated for each source record. If a transformed column is selected, an ID will be generated for each record generated that has this column.")
    InputColumn<?> columnInScope;
    @Configured
    int offset = 0;
    private final AtomicInteger _counter = new AtomicInteger();

    @Initialize
    public void init() {
        this._counter.set(this.offset);
    }

    public OutputColumns getOutputColumns() {
        return new OutputColumns("Generated ID", new String[0]);
    }

    public Integer[] transform(InputRow inputRow) {
        int id = this._counter.incrementAndGet();
        return new Integer[]{id};
    }
}

