/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.analyzer.beans.numbers;

import org.eobjects.analyzer.beans.api.Categorized;
import org.eobjects.analyzer.beans.api.Configured;
import org.eobjects.analyzer.beans.api.Description;
import org.eobjects.analyzer.beans.api.OutputColumns;
import org.eobjects.analyzer.beans.api.Transformer;
import org.eobjects.analyzer.beans.api.TransformerBean;
import org.eobjects.analyzer.beans.categories.DateAndTimeCategory;
import org.eobjects.analyzer.beans.categories.NumbersCategory;
import org.eobjects.analyzer.data.InputColumn;
import org.eobjects.analyzer.data.InputRow;
import org.eobjects.metamodel.util.HasName;

@TransformerBean(value="Generate timestamp")
@Description(value="Generates a timestamp representing the millisecond or nanosecond of processing the record")
@Categorized(value={NumbersCategory.class, DateAndTimeCategory.class})
public class GenerateTimestampTransformer
implements Transformer<Long> {
    @Configured
    @Description(value="A column which represent the scope for which the ID will be generated. If eg. a source column is selected, an ID will be generated for each source record. If a transformed column is selected, an ID will be generated for each record generated that has this column.")
    InputColumn<?> columnInScope;
    @Configured
    Unit unit = Unit.SECOND;

    public OutputColumns getOutputColumns() {
        return new OutputColumns("Generated timestamp", new String[0]);
    }

    public Long[] transform(InputRow inputRow) {
        long result = this.unit == Unit.NANOSECOND ? System.nanoTime() : (this.unit == Unit.SECOND ? System.currentTimeMillis() / 1000L : System.currentTimeMillis());
        return new Long[]{result};
    }

    public static enum Unit implements HasName
    {
        SECOND("Second"),
        MILLISECOND("Millisecond"),
        NANOSECOND("Nanosecond");

        private final String _name;

        private Unit(String name) {
            this._name = name;
        }

        public String getName() {
            return this._name;
        }
    }
}

