/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.analyzer.beans.numbers;

import java.util.UUID;
import org.eobjects.analyzer.beans.api.Categorized;
import org.eobjects.analyzer.beans.api.Configured;
import org.eobjects.analyzer.beans.api.Description;
import org.eobjects.analyzer.beans.api.OutputColumns;
import org.eobjects.analyzer.beans.api.Transformer;
import org.eobjects.analyzer.beans.api.TransformerBean;
import org.eobjects.analyzer.beans.categories.NumbersCategory;
import org.eobjects.analyzer.data.InputColumn;
import org.eobjects.analyzer.data.InputRow;

@TransformerBean(value="Generate UUID")
@Description(value="Generates a universally unique ID")
@Categorized(value={NumbersCategory.class})
public class GenerateUUIDTransformer
implements Transformer<String> {
    @Configured
    @Description(value="A column which represent the scope for which the ID will be generated. If eg. a source column is selected, an ID will be generated for each source record. If a transformed column is selected, an ID will be generated for each record generated that has this column.")
    InputColumn<?> columnInScope;
    @Configured(required=false, order=10)
    String prefix;
    @Configured(required=false, order=11)
    String postfix;

    public OutputColumns getOutputColumns() {
        return new OutputColumns("Generated UUID", new String[0]);
    }

    public String[] transform(InputRow inputRow) {
        String uuid = UUID.randomUUID().toString();
        String result = (this.prefix == null ? "" : this.prefix) + uuid + (this.postfix == null ? "" : this.postfix);
        return new String[]{result};
    }
}

