/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.analyzer.beans.numbers;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.eobjects.analyzer.beans.api.Categorized;
import org.eobjects.analyzer.beans.api.Configured;
import org.eobjects.analyzer.beans.api.Description;
import org.eobjects.analyzer.beans.api.NumberProperty;
import org.eobjects.analyzer.beans.api.OutputColumns;
import org.eobjects.analyzer.beans.api.Transformer;
import org.eobjects.analyzer.beans.api.TransformerBean;
import org.eobjects.analyzer.beans.categories.NumbersCategory;
import org.eobjects.analyzer.data.InputColumn;
import org.eobjects.analyzer.data.InputRow;

@TransformerBean(value="Increment number")
@Description(value="Increment an id, a version or any other number.")
@Categorized(value={NumbersCategory.class})
public class IncrementNumberTransformer
implements Transformer<Number> {
    @Configured
    InputColumn<Number> _number;
    @Configured
    @NumberProperty(zero=false)
    int _increment = 1;

    public OutputColumns getOutputColumns() {
        return new OutputColumns(this._number.getName() + " (incremented)", new String[0]);
    }

    public Number[] transform(InputRow row) {
        Number number = (Number)row.getValue(this._number);
        if (number != null) {
            number = number instanceof Integer || number instanceof Short || number instanceof Byte ? (Number)(number.intValue() + this._increment) : (Number)(number instanceof Long ? (Number)(number.longValue() + (long)this._increment) : (Number)(number instanceof Float ? (Number)Float.valueOf(number.floatValue() + (float)this._increment) : (Number)(number instanceof BigDecimal ? ((BigDecimal)number).add(new BigDecimal(this._increment)) : (number instanceof BigInteger ? ((BigInteger)number).add(new BigInteger("" + this._increment)) : Double.valueOf(number.doubleValue() + (double)this._increment)))));
        }
        return new Number[]{number};
    }
}

