/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.analyzer.beans.numbers;

import org.eobjects.analyzer.beans.api.Categorized;
import org.eobjects.analyzer.beans.api.Configured;
import org.eobjects.analyzer.beans.api.Description;
import org.eobjects.analyzer.beans.api.NumberProperty;
import org.eobjects.analyzer.beans.api.OutputColumns;
import org.eobjects.analyzer.beans.api.Transformer;
import org.eobjects.analyzer.beans.api.TransformerBean;
import org.eobjects.analyzer.beans.categories.NumbersCategory;
import org.eobjects.analyzer.data.InputColumn;
import org.eobjects.analyzer.data.InputRow;

@TransformerBean(value="Round number")
@Description(value="Transformation for rounding a number, typically to the nearest integer, nearest ten, hundred or thousand.")
@Categorized(value={NumbersCategory.class})
public class RoundNumberTransformer
implements Transformer<Integer> {
    @Configured
    InputColumn<Number> _number;
    @Configured
    @Description(value="Defines the factor of rounding. A factor of 1 will round to the nearest integer. A factor of 1000 will round the number to the nearest thousand.")
    @NumberProperty(zero=false, positive=true, negative=false)
    int _roundFactor = 1;

    public OutputColumns getOutputColumns() {
        return new OutputColumns(this._number.getName() + " (rounded)", new String[0]);
    }

    public Integer[] transform(InputRow row) {
        Number number = (Number)row.getValue(this._number);
        if (number != null) {
            number = Math.round(number.doubleValue() / (double)this._roundFactor) * (long)this._roundFactor;
            number = number.intValue();
        }
        return new Integer[]{(Integer)number};
    }
}

