/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.analyzer.beans.transform;

import org.eobjects.analyzer.beans.api.Categorized;
import org.eobjects.analyzer.beans.api.Configured;
import org.eobjects.analyzer.beans.api.Description;
import org.eobjects.analyzer.beans.api.OutputColumns;
import org.eobjects.analyzer.beans.api.Transformer;
import org.eobjects.analyzer.beans.api.TransformerBean;
import org.eobjects.analyzer.beans.categories.StringManipulationCategory;
import org.eobjects.analyzer.data.InputColumn;
import org.eobjects.analyzer.data.InputRow;

@TransformerBean(value="Concatenator")
@Description(value="Concatenate several column values into one.")
@Categorized(value={StringManipulationCategory.class})
public class ConcatenatorTransformer
implements Transformer<String> {
    @Configured
    InputColumn<?>[] columns;
    @Configured(required=false)
    @Description(value="A string to separate the concatenated values")
    String separator;

    public ConcatenatorTransformer(String separator, InputColumn<?>[] columns) {
        this.separator = separator;
        this.columns = columns;
    }

    public ConcatenatorTransformer() {
    }

    public OutputColumns getOutputColumns() {
        StringBuilder sb = new StringBuilder("Concat of ");
        for (int i = 0; i < this.columns.length; ++i) {
            if (i != 0) {
                sb.append(",");
            }
            sb.append(this.columns[i].getName());
            if (i != 4) continue;
            sb.append("...");
            break;
        }
        return new OutputColumns(sb.toString(), new String[0]);
    }

    public String[] transform(InputRow inputRow) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (int i = 0; i < this.columns.length; ++i) {
            InputColumn<?> column = this.columns[i];
            Object value = inputRow.getValue(column);
            if (value == null || "".equals(value)) continue;
            if (!first && this.separator != null) {
                sb.append(this.separator);
            }
            sb.append(value);
            first = false;
        }
        return new String[]{sb.toString()};
    }
}

