/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.analyzer.beans.transform;

import java.util.ArrayList;
import java.util.Date;
import org.eobjects.analyzer.beans.api.Categorized;
import org.eobjects.analyzer.beans.api.Configured;
import org.eobjects.analyzer.beans.api.Description;
import org.eobjects.analyzer.beans.api.OutputColumns;
import org.eobjects.analyzer.beans.api.Transformer;
import org.eobjects.analyzer.beans.api.TransformerBean;
import org.eobjects.analyzer.beans.categories.DateAndTimeCategory;
import org.eobjects.analyzer.data.InputColumn;
import org.eobjects.analyzer.data.InputRow;

@TransformerBean(value="Date difference / period length")
@Description(value="Calculates the length of a period made of two dates")
@Categorized(value={DateAndTimeCategory.class})
public class DateDiffTransformer
implements Transformer<Number> {
    @Configured(order=1)
    InputColumn<Date> fromColumn;
    @Configured(order=2)
    InputColumn<Date> toColumn;
    @Configured(order=3)
    boolean days = true;
    @Configured(order=4)
    boolean hours = false;
    @Configured(order=5)
    boolean minutes = false;
    @Configured(order=6)
    boolean seconds = false;
    @Configured(order=7)
    boolean milliseconds = false;

    public OutputColumns getOutputColumns() {
        ArrayList<String> columnNames = new ArrayList<String>();
        String from = this.fromColumn.getName();
        String to = this.toColumn.getName();
        if (this.days) {
            columnNames.add("Days from " + from + " to " + to);
        }
        if (this.hours) {
            columnNames.add("Hours from " + from + " to " + to);
        }
        if (this.minutes) {
            columnNames.add("Minutes from " + from + " to " + to);
        }
        if (this.seconds) {
            columnNames.add("Seconds from " + from + " to " + to);
        }
        if (this.milliseconds || columnNames.isEmpty()) {
            columnNames.add("Milliseconds from " + from + " to " + to);
        }
        return new OutputColumns(columnNames.toArray(new String[columnNames.size()]));
    }

    public Number[] transform(InputRow inputRow) {
        Date from = (Date)inputRow.getValue(this.fromColumn);
        Date to = (Date)inputRow.getValue(this.toColumn);
        return this.transform(from, to);
    }

    public Number[] transform(Date from, Date to) {
        long fromTime = from == null ? 0L : from.getTime();
        long toTime = to == null ? 0L : to.getTime();
        long diff = toTime - fromTime;
        ArrayList<Long> numbers = new ArrayList<Long>();
        if (this.days) {
            numbers.add(diff / 86400000L);
        }
        if (this.hours) {
            numbers.add(diff / 3600000L);
        }
        if (this.minutes) {
            numbers.add(diff / 60000L);
        }
        if (this.seconds) {
            numbers.add(diff / 1000L);
        }
        if (this.milliseconds || numbers.isEmpty()) {
            numbers.add(diff);
        }
        Number[] result = new Number[numbers.size()];
        if (from == null || to == null) {
            return result;
        }
        return numbers.toArray(result);
    }

    public boolean isHours() {
        return this.hours;
    }

    public void setHours(boolean hours) {
        this.hours = hours;
    }

    public void setDays(boolean days) {
        this.days = days;
    }

    public void setMinutes(boolean minutes) {
        this.minutes = minutes;
    }

    public void setSeconds(boolean seconds) {
        this.seconds = seconds;
    }

    public void setMilliseconds(boolean milliseconds) {
        this.milliseconds = milliseconds;
    }
}

