/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.analyzer.beans.transform;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import org.eobjects.analyzer.beans.api.Categorized;
import org.eobjects.analyzer.beans.api.Configured;
import org.eobjects.analyzer.beans.api.Description;
import org.eobjects.analyzer.beans.api.Initialize;
import org.eobjects.analyzer.beans.api.OutputColumns;
import org.eobjects.analyzer.beans.api.Transformer;
import org.eobjects.analyzer.beans.api.TransformerBean;
import org.eobjects.analyzer.beans.categories.DateAndTimeCategory;
import org.eobjects.analyzer.data.InputColumn;
import org.eobjects.analyzer.data.InputRow;

@TransformerBean(value="Extract date part")
@Description(value="Extract the parts of a date (year, month, day etc.)")
@Categorized(value={DateAndTimeCategory.class})
public class DatePartTransformer
implements Transformer<Number> {
    @Configured(order=1)
    InputColumn<Date> column;
    @Configured(order=2)
    boolean year = true;
    @Configured(order=3)
    boolean month = true;
    @Configured(order=4)
    boolean dayOfMonth = true;
    @Configured(order=5)
    boolean hour = false;
    @Configured(order=6)
    boolean minute = false;
    @Configured(order=7)
    boolean second = false;
    @Configured(order=8)
    boolean dayOfWeek = false;
    @Configured(order=9)
    boolean weekNumber = false;
    @Configured(order=10)
    int minimalDaysInFirstWeek = Calendar.getInstance().getMinimalDaysInFirstWeek();
    @Configured(order=11)
    WeekDay firstDayOfWeek = WeekDay.get(Calendar.getInstance().getFirstDayOfWeek());
    private ArrayList<WeekDay> _indexedWeekDays;

    @Initialize
    public void init() {
        this._indexedWeekDays = new ArrayList(7);
        WeekDay nextWeekDay = this.firstDayOfWeek;
        for (int i = 0; i < 7; ++i) {
            this._indexedWeekDays.add(nextWeekDay);
            nextWeekDay = nextWeekDay.next();
        }
    }

    public OutputColumns getOutputColumns() {
        ArrayList<String> columnNames = new ArrayList<String>();
        String columnName = this.column.getName();
        if (this.year) {
            columnNames.add(columnName + " (year)");
        }
        if (this.month) {
            columnNames.add(columnName + " (month)");
        }
        if (this.dayOfMonth) {
            columnNames.add(columnName + " (day of month)");
        }
        if (this.hour) {
            columnNames.add(columnName + " (hour)");
        }
        if (this.minute) {
            columnNames.add(columnName + " (minute)");
        }
        if (this.second) {
            columnNames.add(columnName + " (second)");
        }
        if (this.dayOfWeek) {
            columnNames.add(columnName + " (day of week)");
        }
        if (this.weekNumber) {
            columnNames.add(columnName + " (week number)");
        }
        if (columnNames.isEmpty()) {
            columnNames.add(columnName + " (year)");
        }
        return new OutputColumns(columnNames.toArray(new String[columnNames.size()]));
    }

    public Number[] transform(InputRow inputRow) {
        Date value = (Date)inputRow.getValue(this.column);
        return this.transform(value);
    }

    public Number[] transform(Date date) {
        Calendar cal;
        if (date == null) {
            cal = null;
        } else {
            cal = Calendar.getInstance();
            cal.setFirstDayOfWeek(this.firstDayOfWeek.getCalendarInt());
            cal.setMinimalDaysInFirstWeek(this.minimalDaysInFirstWeek);
            cal.setTime(date);
        }
        ArrayList<Number> result = new ArrayList<Number>();
        if (this.year) {
            result.add(this.getYear(cal));
        }
        if (this.month) {
            result.add(this.getMonth(cal));
        }
        if (this.dayOfMonth) {
            result.add(this.getDayOfMonth(cal));
        }
        if (this.hour) {
            result.add(this.getHour(cal));
        }
        if (this.minute) {
            result.add(this.getMinute(cal));
        }
        if (this.second) {
            result.add(this.getSecond(cal));
        }
        if (this.dayOfWeek) {
            result.add(this.getDayOfWeek(cal));
        }
        if (this.weekNumber) {
            result.add(this.getWeekNumber(cal));
        }
        if (result.isEmpty()) {
            result.add(this.getYear(cal));
        }
        return result.toArray(new Number[result.size()]);
    }

    private Number getWeekNumber(Calendar cal) {
        if (cal == null) {
            return null;
        }
        return cal.get(3);
    }

    private Number getDayOfWeek(Calendar cal) {
        if (cal == null) {
            return null;
        }
        WeekDay weekDay = WeekDay.get(cal.get(7));
        return this._indexedWeekDays.indexOf((Object)weekDay) + 1;
    }

    private Number getSecond(Calendar cal) {
        if (cal == null) {
            return null;
        }
        return cal.get(13);
    }

    private Number getMinute(Calendar cal) {
        if (cal == null) {
            return null;
        }
        return cal.get(12);
    }

    private Number getHour(Calendar cal) {
        if (cal == null) {
            return null;
        }
        return cal.get(11);
    }

    private Number getDayOfMonth(Calendar cal) {
        if (cal == null) {
            return null;
        }
        return cal.get(5);
    }

    private Number getMonth(Calendar cal) {
        if (cal == null) {
            return null;
        }
        return cal.get(2) + 1;
    }

    private Number getYear(Calendar cal) {
        if (cal == null) {
            return null;
        }
        return cal.get(1);
    }

    public static enum WeekDay {
        MONDAY(2),
        TUESDAY(3),
        WEDNESDAY(4),
        THURSDAY(5),
        FRIDAY(6),
        SATURDAY(7),
        SUNDAY(1);

        private final int _calendarInt;

        private WeekDay(int calendarInt) {
            this._calendarInt = calendarInt;
        }

        public int getCalendarInt() {
            return this._calendarInt;
        }

        public static WeekDay get(int firstDayOfWeek) {
            for (WeekDay weekDay : WeekDay.values()) {
                if (firstDayOfWeek != weekDay.getCalendarInt()) continue;
                return weekDay;
            }
            return null;
        }

        public WeekDay next() {
            if (this == SUNDAY) {
                return MONDAY;
            }
            return WeekDay.values()[this.ordinal() + 1];
        }
    }
}

