/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.analyzer.beans.transform;

import java.util.Date;
import org.eobjects.analyzer.beans.api.Categorized;
import org.eobjects.analyzer.beans.api.Configured;
import org.eobjects.analyzer.beans.api.Description;
import org.eobjects.analyzer.beans.api.OutputColumns;
import org.eobjects.analyzer.beans.api.Transformer;
import org.eobjects.analyzer.beans.api.TransformerBean;
import org.eobjects.analyzer.beans.categories.DateAndTimeCategory;
import org.eobjects.analyzer.data.InputColumn;
import org.eobjects.analyzer.data.InputRow;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.Years;

@TransformerBean(value="Date to age")
@Description(value="Turn a Date-column into columns of age (both in years and in days).")
@Categorized(value={DateAndTimeCategory.class})
public class DateToAgeTransformer
implements Transformer<Integer> {
    @Configured(value="Date column")
    InputColumn<Date> dateColumn;
    private Date today = new Date();

    public OutputColumns getOutputColumns() {
        return new OutputColumns("Age in days", new String[]{"Age in years"});
    }

    public Integer[] transform(InputRow inputRow) {
        Integer[] result = new Integer[2];
        Date date = (Date)inputRow.getValue(this.dateColumn);
        if (date != null) {
            long diffMillis = this.today.getTime() - date.getTime();
            int diffDays = (int)(diffMillis / 86400000L);
            result[0] = diffDays;
            int diffYears = Years.yearsBetween((ReadableInstant)new DateTime((Object)date), (ReadableInstant)new DateTime((Object)this.today)).getYears();
            result[1] = diffYears;
        }
        return result;
    }

    public void setToday(Date today) {
        this.today = today;
    }

    public void setDateColumn(InputColumn<Date> dateColumn) {
        this.dateColumn = dateColumn;
    }
}

