/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.analyzer.beans.transform;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.eobjects.analyzer.beans.api.Categorized;
import org.eobjects.analyzer.beans.api.Configured;
import org.eobjects.analyzer.beans.api.Description;
import org.eobjects.analyzer.beans.api.OutputColumns;
import org.eobjects.analyzer.beans.api.Transformer;
import org.eobjects.analyzer.beans.api.TransformerBean;
import org.eobjects.analyzer.beans.categories.DateAndTimeCategory;
import org.eobjects.analyzer.data.InputColumn;
import org.eobjects.analyzer.data.InputRow;

@TransformerBean(value="Format date")
@Description(value="Allows you to format a date as a string by applying your own date format.")
@Categorized(value={DateAndTimeCategory.class})
public class FormatDateTransformer
implements Transformer<String> {
    @Configured(value="Date")
    InputColumn<Date> dateColumn;
    @Configured
    String dateFormat = "yyyy-MM-dd HH:mm:ss";

    public OutputColumns getOutputColumns() {
        return new OutputColumns(this.dateColumn.getName() + " (formatted)", new String[0]);
    }

    public String[] transform(InputRow inputRow) {
        Date date = (Date)inputRow.getValue(this.dateColumn);
        if (date == null) {
            return new String[]{null};
        }
        SimpleDateFormat format = new SimpleDateFormat(this.dateFormat);
        return new String[]{format.format(date)};
    }
}

