/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.analyzer.beans.transform;

import org.eobjects.analyzer.beans.api.Categorized;
import org.eobjects.analyzer.beans.api.Configured;
import org.eobjects.analyzer.beans.api.Description;
import org.eobjects.analyzer.beans.api.OutputColumns;
import org.eobjects.analyzer.beans.api.StringProperty;
import org.eobjects.analyzer.beans.api.Transformer;
import org.eobjects.analyzer.beans.api.TransformerBean;
import org.eobjects.analyzer.beans.api.Validate;
import org.eobjects.analyzer.beans.categories.StringManipulationCategory;
import org.eobjects.analyzer.data.InputColumn;
import org.eobjects.analyzer.data.InputRow;

@TransformerBean(value="Plain search/replace")
@Description(value="Search and replace text in String values.")
@Categorized(value={StringManipulationCategory.class})
public class PlainSearchReplaceTransformer
implements Transformer<String> {
    @Configured(value="Value", order=1)
    InputColumn<String> valueColumn;
    @Configured(order=2)
    String searchString;
    @Configured(order=3)
    @StringProperty(emptyString=true)
    String replacementString = "";
    @Configured(order=4)
    @Description(value="Replace the entire string when the search string is found.")
    boolean replaceEntireString = false;

    @Validate
    public void validate() {
        if (!this.replaceEntireString && this.replacementString.indexOf(this.searchString) != -1) {
            throw new IllegalArgumentException("Replacement string cannot contain the search string (implies an infinite replacement loop)");
        }
    }

    public OutputColumns getOutputColumns() {
        return new OutputColumns(this.valueColumn.getName() + " (replaced '" + this.searchString + "')", new String[0]);
    }

    public String[] transform(InputRow row) {
        String[] result = new String[1];
        String value = (String)row.getValue(this.valueColumn);
        if (value == null) {
            return result;
        }
        if (this.replaceEntireString) {
            if (this.matchesSearchString(value)) {
                value = this.replacementString;
            }
        } else {
            while (this.matchesSearchString(value)) {
                value = value.replace(this.searchString, this.replacementString);
            }
        }
        result[0] = value;
        return result;
    }

    private boolean matchesSearchString(String value) {
        return value.indexOf(this.searchString) != -1;
    }
}

