/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.analyzer.beans.transform;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eobjects.analyzer.beans.api.Categorized;
import org.eobjects.analyzer.beans.api.Configured;
import org.eobjects.analyzer.beans.api.Description;
import org.eobjects.analyzer.beans.api.OutputColumns;
import org.eobjects.analyzer.beans.api.Transformer;
import org.eobjects.analyzer.beans.api.TransformerBean;
import org.eobjects.analyzer.beans.categories.MatchingAndStandardizationCategory;
import org.eobjects.analyzer.beans.categories.ScriptingCategory;
import org.eobjects.analyzer.beans.categories.StringManipulationCategory;
import org.eobjects.analyzer.data.InputColumn;
import org.eobjects.analyzer.data.InputRow;

@TransformerBean(value="Regex parser")
@Description(value="Parses strings using a regular expression and transforms it into substrings based on regex groups")
@Categorized(value={StringManipulationCategory.class, ScriptingCategory.class, MatchingAndStandardizationCategory.class})
public class RegexParserTransformer
implements Transformer<String> {
    @Configured
    InputColumn<String> column;
    @Configured
    @Description(value="A regular expression containing\ngroup tokens, marked by parantheses.\n\nFor example:\n([a-z]+)_(\\d*)")
    Pattern pattern;

    public OutputColumns getOutputColumns() {
        String[] columns = new String[this.pattern.matcher("").groupCount()];
        for (int i = 0; i < columns.length; ++i) {
            columns[i] = this.column.getName() + " (group " + (i + 1) + ")";
        }
        return new OutputColumns(this.column.getName() + " (matched part)", columns);
    }

    public String[] transform(InputRow inputRow) {
        Matcher matcher = this.pattern.matcher("");
        String value = (String)inputRow.getValue(this.column);
        boolean match = value != null && matcher.reset(value).matches();
        String[] result = new String[matcher.groupCount() + 1];
        for (int i = 0; i < result.length; ++i) {
            result[i] = match ? matcher.group(i) : null;
        }
        return result;
    }
}

