/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.analyzer.beans.transform;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eobjects.analyzer.beans.api.Categorized;
import org.eobjects.analyzer.beans.api.Configured;
import org.eobjects.analyzer.beans.api.Description;
import org.eobjects.analyzer.beans.api.OutputColumns;
import org.eobjects.analyzer.beans.api.Transformer;
import org.eobjects.analyzer.beans.api.TransformerBean;
import org.eobjects.analyzer.beans.categories.StringManipulationCategory;
import org.eobjects.analyzer.data.InputColumn;
import org.eobjects.analyzer.data.InputRow;

@TransformerBean(value="Regex search/replace")
@Description(value="Search and replace text in String values using regular expressions.")
@Categorized(value={StringManipulationCategory.class})
public class RegexSearchReplaceTransformer
implements Transformer<String> {
    @Configured(value="Value", order=1)
    InputColumn<String> valueColumn;
    @Configured(order=2)
    @Description(value="Regular expression pattern used for searching. Eg. 'Mr\\. (\\w+)'")
    Pattern searchPattern;
    @Configured(order=3)
    @Description(value="Regular expression pattern used for replacement. Eg. 'Mister $1'")
    Pattern replacementPattern;

    public OutputColumns getOutputColumns() {
        return new OutputColumns(this.valueColumn.getName() + " (replaced '" + this.searchPattern.pattern() + "')", new String[0]);
    }

    public String[] transform(InputRow row) {
        String replacedString;
        String[] result = new String[1];
        String value = (String)row.getValue(this.valueColumn);
        if (value == null) {
            return result;
        }
        Matcher matcher = this.searchPattern.matcher(value);
        result[0] = replacedString = matcher.replaceAll(this.replacementPattern.pattern());
        return result;
    }
}

