/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.analyzer.beans.transform;

import org.eobjects.analyzer.beans.api.Categorized;
import org.eobjects.analyzer.beans.api.Configured;
import org.eobjects.analyzer.beans.api.Description;
import org.eobjects.analyzer.beans.api.OutputColumns;
import org.eobjects.analyzer.beans.api.Transformer;
import org.eobjects.analyzer.beans.api.TransformerBean;
import org.eobjects.analyzer.beans.categories.StringManipulationCategory;
import org.eobjects.analyzer.data.InputColumn;
import org.eobjects.analyzer.data.InputRow;
import org.eobjects.analyzer.util.CharIterator;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;

@TransformerBean(value="Remove unwanted characters")
@Description(value="Removes characters from strings that are not wanted. Use it to cleanse codes and identifiers that may have additional dashes, punctuations, unwanted letters etc.")
@Categorized(value={StringManipulationCategory.class})
@ScalaSignature(bytes="\u0006\u0001\u0005\u001dc\u0001B\u0001\u0003\u00015\u0011aDU3n_Z,WK\\<b]R,Gm\u00115beN$&/\u00198tM>\u0014X.\u001a:\u000b\u0005\r!\u0011!\u0003;sC:\u001chm\u001c:n\u0015\t)a!A\u0003cK\u0006t7O\u0003\u0002\b\u0011\u0005A\u0011M\\1msj,'O\u0003\u0002\n\u0015\u0005AQm\u001c2kK\u000e$8OC\u0001\f\u0003\ry'oZ\u0002\u0001'\r\u0001aB\u0006\t\u0003\u001fQi\u0011\u0001\u0005\u0006\u0003#I\tA\u0001\\1oO*\t1#\u0001\u0003kCZ\f\u0017BA\u000b\u0011\u0005\u0019y%M[3diB\u0019qC\u0007\u000f\u000e\u0003aQ!!\u0007\u0003\u0002\u0007\u0005\u0004\u0018.\u0003\u0002\u001c1\tYAK]1og\u001a|'/\\3s!\ti2E\u0004\u0002\u001fC5\tqDC\u0001!\u0003\u0015\u00198-\u00197b\u0013\t\u0011s$\u0001\u0004Qe\u0016$WMZ\u0005\u0003I\u0015\u0012aa\u0015;sS:<'B\u0001\u0012 \u0011!9\u0003A!A!\u0002\u0013A\u0013aA2pYB\u0019\u0011\u0006\f\u000f\u000e\u0003)R!a\u000b\u0004\u0002\t\u0011\fG/Y\u0005\u0003[)\u00121\"\u00138qkR\u001cu\u000e\\;n]\")q\u0006\u0001C\u0001a\u00051A(\u001b8jiz\"\"!M\u001a\u0011\u0005I\u0002Q\"\u0001\u0002\t\u000b\u001dr\u0003\u0019\u0001\u0015\t\u000fU\u0002\u0001\u0019!C\u0001m\u000511m\u001c7v[:,\u0012\u0001\u000b\u0005\bq\u0001\u0001\r\u0011\"\u0001:\u0003)\u0019w\u000e\\;n]~#S-\u001d\u000b\u0003uu\u0002\"AH\u001e\n\u0005qz\"\u0001B+oSRDqAP\u001c\u0002\u0002\u0003\u0007\u0001&A\u0002yIEBa\u0001\u0011\u0001!B\u0013A\u0013aB2pYVlg\u000e\t\u0015\u0003\u007f\t\u0003\"aF\"\n\u0005\u0011C\"AC\"p]\u001aLw-\u001e:fI\"9a\t\u0001a\u0001\n\u00039\u0015!\u0005:f[>4Xm\u00165ji\u0016\u001c\b/Y2fgV\t\u0001\n\u0005\u0002\u001f\u0013&\u0011!j\b\u0002\b\u0005>|G.Z1o\u0011\u001da\u0005\u00011A\u0005\u00025\u000bQC]3n_Z,w\u000b[5uKN\u0004\u0018mY3t?\u0012*\u0017\u000f\u0006\u0002;\u001d\"9ahSA\u0001\u0002\u0004A\u0005B\u0002)\u0001A\u0003&\u0001*\u0001\nsK6|g/Z,iSR,7\u000f]1dKN\u0004\u0003\u0006B(C%N\u000bQa\u001c:eKJl\u0012!\u0001\u0005\b+\u0002\u0001\r\u0011\"\u0001H\u00035\u0011X-\\8wK2+G\u000f^3sg\"9q\u000b\u0001a\u0001\n\u0003A\u0016!\u0005:f[>4X\rT3ui\u0016\u00148o\u0018\u0013fcR\u0011!(\u0017\u0005\b}Y\u000b\t\u00111\u0001I\u0011\u0019Y\u0006\u0001)Q\u0005\u0011\u0006q!/Z7pm\u0016dU\r\u001e;feN\u0004\u0003\u0006\u0002.C%vk\u0012A\u0001\u0005\b?\u0002\u0001\r\u0011\"\u0001H\u00031\u0011X-\\8wK\u0012Kw-\u001b;t\u0011\u001d\t\u0007\u00011A\u0005\u0002\t\f\u0001C]3n_Z,G)[4jiN|F%Z9\u0015\u0005i\u001a\u0007b\u0002 a\u0003\u0003\u0005\r\u0001\u0013\u0005\u0007K\u0002\u0001\u000b\u0015\u0002%\u0002\u001bI,Wn\u001c<f\t&<\u0017\u000e^:!Q\u0011!'IU4\u001e\u0003\rAq!\u001b\u0001A\u0002\u0013\u0005q)A\u0006sK6|g/Z*jO:\u001c\bbB6\u0001\u0001\u0004%\t\u0001\\\u0001\u0010e\u0016lwN^3TS\u001et7o\u0018\u0013fcR\u0011!(\u001c\u0005\b})\f\t\u00111\u0001I\u0011\u0019y\u0007\u0001)Q\u0005\u0011\u0006a!/Z7pm\u0016\u001c\u0016n\u001a8tA!\"a.\u001d;v!\t9\"/\u0003\u0002t1\tYA)Z:de&\u0004H/[8o\u0003\u00151\u0018\r\\;fC\u00051\u0018\u0001\u0013*f[>4X\rI1eI&$\u0018n\u001c8bY\u0002\u001a\u0018n\u001a8tY\u0001\u001aXo\u00195!CN\u0004C-Y:iKNd\u0003\u0005];oGRL\u0017\r^5p]Nd\u0003e\u001d7bg\",7\u000fI1oI\u0002jwN]3@Q\u0011q'I\u0015=\u001e\u0003\u0011AQa\f\u0001\u0005\u0002i$\u0012!\r\u0005\u0006y\u0002!\t!`\u0001\u0011O\u0016$x*\u001e;qkR\u001cu\u000e\\;n]N$\u0012A \t\u0003/}L1!!\u0001\u0019\u00055yU\u000f\u001e9vi\u000e{G.^7og\"11\u0001\u0001C\u0001\u0003\u000b!B!a\u0002\u0002\u000eA!a$!\u0003\u001d\u0013\r\tYa\b\u0002\u0006\u0003J\u0014\u0018-\u001f\u0005\t\u0003\u001f\t\u0019\u00011\u0001\u0002\u0012\u0005\u0019!o\\<\u0011\u0007%\n\u0019\"C\u0002\u0002\u0016)\u0012\u0001\"\u00138qkR\u0014vn\u001e\u0005\u0007\u0007\u0001!\t!!\u0007\u0015\t\u0005\u001d\u00111\u0004\u0005\u0007i\u0006]\u0001\u0019\u0001\u000f)\r\u0001\ty\u0002^A\u0013!\r9\u0012\u0011E\u0005\u0004\u0003GA\"aC\"bi\u0016<wN]5{K\u0012d#!a\n$\u0005\u0005%\u0002\u0003BA\u0016\u0003ci!!!\f\u000b\u0007\u0005=B!\u0001\u0006dCR,wm\u001c:jKNLA!a\r\u0002.\tQ2\u000b\u001e:j]\u001el\u0015M\\5qk2\fG/[8o\u0007\u0006$XmZ8ss\"*\u0001!\u001d;\u00028\u0005\u0012\u0011\u0011H\u0001\u0002DI+Wn\u001c<fg\u0002\u001a\u0007.\u0019:bGR,'o\u001d\u0011ge>l\u0007e\u001d;sS:<7\u000f\t;iCR\u0004\u0013M]3!]>$\be^1oi\u0016$g\u0006I+tK\u0002JG\u000f\t;pA\rdW-\u00198tK\u0002\u001aw\u000eZ3tA\u0005tG\rI5eK:$\u0018NZ5feN\u0004C\u000f[1uA5\f\u0017\u0010\t5bm\u0016\u0004\u0013\r\u001a3ji&|g.\u00197!I\u0006\u001c\b.Z:-AA,hn\u0019;vCRLwN\\:-AUtw/\u00198uK\u0012\u0004C.\u001a;uKJ\u001c\b%\u001a;d]!2\u0001!!\u0010u\u0003\u0007\u00022aFA \u0013\r\t\t\u0005\u0007\u0002\u0010)J\fgn\u001d4pe6,'OQ3b]\u0006\u0012\u0011QI\u0001\u001b%\u0016lwN^3!k:<\u0018M\u001c;fI\u0002\u001a\u0007.\u0019:bGR,'o\u001d")
public class RemoveUnwantedCharsTransformer
implements Transformer<String> {
    @Configured
    private InputColumn<String> column;
    @Configured(order=1)
    private boolean removeWhitespaces;
    @Configured(order=2)
    private boolean removeLetters;
    @Configured(order=3)
    private boolean removeDigits;
    @Configured(order=4)
    @Description(value="Remove additional signs, such as dashes, punctiations, slashes and more?")
    private boolean removeSigns;

    public InputColumn<String> column() {
        return this.column;
    }

    public void column_$eq(InputColumn<String> x$1) {
        this.column = x$1;
    }

    public boolean removeWhitespaces() {
        return this.removeWhitespaces;
    }

    public void removeWhitespaces_$eq(boolean x$1) {
        this.removeWhitespaces = x$1;
    }

    public boolean removeLetters() {
        return this.removeLetters;
    }

    public void removeLetters_$eq(boolean x$1) {
        this.removeLetters = x$1;
    }

    public boolean removeDigits() {
        return this.removeDigits;
    }

    public void removeDigits_$eq(boolean x$1) {
        this.removeDigits = x$1;
    }

    public boolean removeSigns() {
        return this.removeSigns;
    }

    public void removeSigns_$eq(boolean x$1) {
        this.removeSigns = x$1;
    }

    public OutputColumns getOutputColumns() {
        return new OutputColumns(new StringBuilder().append((Object)this.column().getName()).append((Object)" (cleansed)").toString(), new String[0]);
    }

    public String[] transform(InputRow row) {
        String value = (String)row.getValue(this.column());
        return this.transform(value);
    }

    public String[] transform(String value) {
        if (value == null) {
            String[] stringArray = new String[1];
            stringArray[0] = null;
            return (String[])((Object[])stringArray);
        }
        CharIterator it = new CharIterator((CharSequence)value);
        while (it.hasNext()) {
            Character c = it.next();
            if (it.isWhitespace()) {
                if (!this.removeWhitespaces()) continue;
                it.remove();
                continue;
            }
            if (it.isLetter()) {
                if (!this.removeLetters()) continue;
                it.remove();
                continue;
            }
            if (it.isDigit()) {
                if (!this.removeDigits()) continue;
                it.remove();
                continue;
            }
            if (!this.removeSigns()) continue;
            it.remove();
        }
        return (String[])((Object[])new String[]{it.toString()});
    }

    public RemoveUnwantedCharsTransformer(InputColumn<String> col) {
        this.column = col;
        this.removeWhitespaces = true;
        this.removeLetters = true;
        this.removeDigits = false;
        this.removeSigns = true;
    }

    public RemoveUnwantedCharsTransformer() {
        this(null);
    }
}

