/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.analyzer.beans.transform;

import org.eobjects.analyzer.beans.api.Categorized;
import org.eobjects.analyzer.beans.api.Configured;
import org.eobjects.analyzer.beans.api.Description;
import org.eobjects.analyzer.beans.api.OutputColumns;
import org.eobjects.analyzer.beans.api.Transformer;
import org.eobjects.analyzer.beans.api.TransformerBean;
import org.eobjects.analyzer.beans.categories.StringManipulationCategory;
import org.eobjects.analyzer.data.InputColumn;
import org.eobjects.analyzer.data.InputRow;
import scala.Predef$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;

@TransformerBean(value="String length")
@Description(value="Counts the length of Strings and creates a separate column with this metric.")
@Categorized(value={StringManipulationCategory.class})
@ScalaSignature(bytes="\u0006\u0001e4A!\u0001\u0002\u0001\u001b\t92\u000b\u001e:j]\u001edUM\\4uQR\u0013\u0018M\\:g_JlWM\u001d\u0006\u0003\u0007\u0011\t\u0011\u0002\u001e:b]N4wN]7\u000b\u0005\u00151\u0011!\u00022fC:\u001c(BA\u0004\t\u0003!\tg.\u00197zu\u0016\u0014(BA\u0005\u000b\u0003!)wN\u00196fGR\u001c(\"A\u0006\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u0001qa\u0003\u0005\u0002\u0010)5\t\u0001C\u0003\u0002\u0012%\u0005!A.\u00198h\u0015\u0005\u0019\u0012\u0001\u00026bm\u0006L!!\u0006\t\u0003\r=\u0013'.Z2u!\r9\"\u0004H\u0007\u00021)\u0011\u0011\u0004B\u0001\u0004CBL\u0017BA\u000e\u0019\u0005-!&/\u00198tM>\u0014X.\u001a:\u0011\u0005=i\u0012B\u0001\u0010\u0011\u0005\u0019qU/\u001c2fe\"A\u0001\u0005\u0001B\u0001B\u0003%\u0011%A\u0002d_2\u00042AI\u0013(\u001b\u0005\u0019#B\u0001\u0013\u0007\u0003\u0011!\u0017\r^1\n\u0005\u0019\u001a#aC%oaV$8i\u001c7v[:\u0004\"\u0001\u000b\u0018\u000f\u0005%bS\"\u0001\u0016\u000b\u0003-\nQa]2bY\u0006L!!\f\u0016\u0002\rA\u0013X\rZ3g\u0013\ty\u0003G\u0001\u0004TiJLgn\u001a\u0006\u0003[)BQA\r\u0001\u0005\u0002M\na\u0001P5oSRtDC\u0001\u001b7!\t)\u0004!D\u0001\u0003\u0011\u0015\u0001\u0013\u00071\u0001\"\u0011\u001dA\u0004\u00011A\u0005\u0002e\naaY8mk6tW#A\u0011\t\u000fm\u0002\u0001\u0019!C\u0001y\u0005Q1m\u001c7v[:|F%Z9\u0015\u0005u\u0002\u0005CA\u0015?\u0013\ty$F\u0001\u0003V]&$\bbB!;\u0003\u0003\u0005\r!I\u0001\u0004q\u0012\n\u0004BB\"\u0001A\u0003&\u0011%A\u0004d_2,XN\u001c\u0011)\t\t+\u0005*\u0013\t\u0003/\u0019K!a\u0012\r\u0003\u0017\u0011+7o\u0019:jaRLwN\\\u0001\u0006m\u0006dW/Z\u0011\u0002\u0015\u0006)3i\u001c7v[:\u0004Co\u001c\u0011d_6\u0004X\u000f^3!gR\u0014\u0018N\\4!Y\u0016tw\r\u001e5tA\u0019\u0014x.\u001c\u0015\u0003\u00052\u0003\"aF'\n\u00059C\"AC\"p]\u001aLw-\u001e:fI\")!\u0007\u0001C\u0001!R\tA\u0007C\u0003S\u0001\u0011\u00051+\u0001\thKR|U\u000f\u001e9vi\u000e{G.^7ogR\tA\u000b\u0005\u0002\u0018+&\u0011a\u000b\u0007\u0002\u000e\u001fV$\b/\u001e;D_2,XN\\:\t\u000b\r\u0001A\u0011\u0001-\u0015\u0005ec\u0006cA\u0015[9%\u00111L\u000b\u0002\u0006\u0003J\u0014\u0018-\u001f\u0005\u0006;^\u0003\rAX\u0001\u0004e><\bC\u0001\u0012`\u0013\t\u00017E\u0001\u0005J]B,HOU8x\u0011\u0015\u0019\u0001\u0001\"\u0001c)\tI6\rC\u0003IC\u0002\u0007q\u0005\u000b\u0003\u0001K\"C\u0007CA\fg\u0013\t9\u0007DA\u0006DCR,wm\u001c:ju\u0016$G&A5$\u0003)\u0004\"a\u001b8\u000e\u00031T!!\u001c\u0003\u0002\u0015\r\fG/Z4pe&,7/\u0003\u0002pY\nQ2\u000b\u001e:j]\u001el\u0015M\\5qk2\fG/[8o\u0007\u0006$XmZ8ss\"\"\u0001!\u0012%rC\u0005\u0011\u0018\u0001T\"pk:$8\u000f\t;iK\u0002bWM\\4uQ\u0002zg\rI*ue&twm\u001d\u0011b]\u0012\u00043M]3bi\u0016\u001c\b%\u0019\u0011tKB\f'/\u0019;fA\r|G.^7oA]LG\u000f\u001b\u0011uQ&\u001c\b%\\3ue&\u001cg\u0006\u000b\u0003\u0001i\";\bCA\fv\u0013\t1\bDA\bUe\u0006t7OZ8s[\u0016\u0014()Z1oC\u0005A\u0018!D*ue&tw\r\t7f]\u001e$\b\u000e")
public class StringLengthTransformer
implements Transformer<Number> {
    @Configured
    @Description(value="Column to compute string lengths from")
    private InputColumn<String> column;

    public InputColumn<String> column() {
        return this.column;
    }

    public void column_$eq(InputColumn<String> x$1) {
        this.column = x$1;
    }

    public OutputColumns getOutputColumns() {
        return new OutputColumns(new StringBuilder().append((Object)this.column().getName()).append((Object)" length").toString(), new String[0]);
    }

    public Number[] transform(InputRow row) {
        String value = (String)row.getValue(this.column());
        return this.transform(value);
    }

    public Number[] transform(String value) {
        if (value == null) {
            Number[] numberArray = new Number[1];
            numberArray[0] = null;
            return (Number[])((Object[])numberArray);
        }
        return (Number[])((Object[])new Number[]{Predef$.MODULE$.int2Integer(value.length())});
    }

    public StringLengthTransformer(InputColumn<String> col) {
        this.column = col;
    }

    public StringLengthTransformer() {
        this(null);
    }
}

