/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.analyzer.beans.transform;

import java.util.StringTokenizer;
import org.eobjects.analyzer.beans.api.Categorized;
import org.eobjects.analyzer.beans.api.Configured;
import org.eobjects.analyzer.beans.api.Description;
import org.eobjects.analyzer.beans.api.OutputColumns;
import org.eobjects.analyzer.beans.api.Transformer;
import org.eobjects.analyzer.beans.api.TransformerBean;
import org.eobjects.analyzer.beans.categories.StringManipulationCategory;
import org.eobjects.analyzer.data.InputColumn;
import org.eobjects.analyzer.data.InputRow;
import org.eobjects.metamodel.util.HasName;

@TransformerBean(value="Text case transformer")
@Description(value="Modifies the text case/capitalization of Strings.")
@Categorized(value={StringManipulationCategory.class})
public class TextCaseTransformer
implements Transformer<String> {
    @Configured(value="Value")
    InputColumn<String> valueColumn;
    @Configured
    TransformationMode mode;

    public OutputColumns getOutputColumns() {
        return new OutputColumns(this.valueColumn.getName() + " (" + this.mode.getName() + ")", new String[0]);
    }

    public String[] transform(InputRow row) {
        String value = (String)row.getValue(this.valueColumn);
        String[] result = new String[]{this.transform(value)};
        return result;
    }

    public String transform(String value) {
        if (value == null) {
            return null;
        }
        switch (this.mode) {
            case UPPER_CASE: {
                return value.toUpperCase();
            }
            case LOWER_CASE: {
                return value.toLowerCase();
            }
            case CAPITALIZE_SENTENCES: 
            case CAPITALIZE_WORDS: {
                return this.capitalizeWords(value);
            }
        }
        throw new UnsupportedOperationException("Unsupported mode: " + (Object)((Object)this.mode));
    }

    private String capitalizeWords(String value) {
        StringBuilder sb = new StringBuilder();
        StringTokenizer tokenizer = new StringTokenizer(value, " \t\n\r\f", true);
        boolean capitalizeNext = true;
        while (tokenizer.hasMoreTokens()) {
            String nextToken = tokenizer.nextToken();
            String lowerCasedToken = nextToken.toLowerCase();
            if (capitalizeNext) {
                String capitalizedToken = Character.toUpperCase(lowerCasedToken.charAt(0)) + lowerCasedToken.substring(1);
                sb.append(capitalizedToken);
            } else {
                sb.append(lowerCasedToken);
            }
            char lastChar = lowerCasedToken.charAt(lowerCasedToken.length() - 1);
            capitalizeNext = this.mode == TransformationMode.CAPITALIZE_WORDS || this.isCapitalizeTrigger(lastChar);
        }
        return sb.toString();
    }

    private boolean isCapitalizeTrigger(char c) {
        return c == '.' || c == '!' || c == '?' || c == ':';
    }

    public static enum TransformationMode implements HasName
    {
        LOWER_CASE("Lower case"),
        UPPER_CASE("Upper case"),
        CAPITALIZE_SENTENCES("Capitalize sentences"),
        CAPITALIZE_WORDS("Capitalize every word");

        private final String _name;

        private TransformationMode(String name) {
            this._name = name;
        }

        public String getName() {
            return this._name;
        }
    }
}

