/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.analyzer.beans.transform;

import java.util.Date;
import org.eobjects.analyzer.beans.api.Categorized;
import org.eobjects.analyzer.beans.api.Configured;
import org.eobjects.analyzer.beans.api.Description;
import org.eobjects.analyzer.beans.api.OutputColumns;
import org.eobjects.analyzer.beans.api.Transformer;
import org.eobjects.analyzer.beans.api.TransformerBean;
import org.eobjects.analyzer.beans.categories.DateAndTimeCategory;
import org.eobjects.analyzer.beans.convert.ConvertToNumberTransformer;
import org.eobjects.analyzer.data.InputColumn;
import org.eobjects.analyzer.data.InputRow;
import org.eobjects.metamodel.util.HasName;

@TransformerBean(value="Timestamp converter")
@Description(value="Convert a timestamp (string or number) to a date field. Epoch is assumed to be 1970-01-01.")
@Categorized(value={DateAndTimeCategory.class})
public class TimestampConverter
implements Transformer<Date> {
    @Configured
    InputColumn<?> timestampColumn;
    @Configured
    @Description(value="The unit of measure for comparing the timestamp to the epoch")
    Unit unit = Unit.SECONDS;

    public OutputColumns getOutputColumns() {
        return new OutputColumns(this.timestampColumn.getName() + " (as date)", new String[0]);
    }

    public Date[] transform(InputRow inputRow) {
        Date[] result = new Date[1];
        Object value = inputRow.getValue(this.timestampColumn);
        Number number = ConvertToNumberTransformer.transformValue((Object)value);
        if (number != null) {
            Date timestampedDate;
            result[0] = timestampedDate = new Date(number.longValue() * (long)this.unit.getMillisPerUnit());
        }
        return result;
    }

    public static enum Unit implements HasName
    {
        DAYS("Days", 86400000),
        HOURS("Hours", 3600000),
        MINUTES("Minutes", 60000),
        SECONDS("Seconds", 1000),
        MILLIS("Milliseconds", 1);

        private final String _name;
        private final int _millisPerUnit;

        private Unit(String name, int millisPerUnit) {
            this._name = name;
            this._millisPerUnit = millisPerUnit;
        }

        public String getName() {
            return this._name;
        }

        public int getMillisPerUnit() {
            return this._millisPerUnit;
        }
    }
}

