/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.analyzer.beans.transform;

import java.util.StringTokenizer;
import javax.inject.Inject;
import org.eobjects.analyzer.beans.api.Categorized;
import org.eobjects.analyzer.beans.api.Configured;
import org.eobjects.analyzer.beans.api.Description;
import org.eobjects.analyzer.beans.api.NumberProperty;
import org.eobjects.analyzer.beans.api.OutputColumns;
import org.eobjects.analyzer.beans.api.OutputRowCollector;
import org.eobjects.analyzer.beans.api.Provided;
import org.eobjects.analyzer.beans.api.Transformer;
import org.eobjects.analyzer.beans.api.TransformerBean;
import org.eobjects.analyzer.beans.categories.StringManipulationCategory;
import org.eobjects.analyzer.data.InputColumn;
import org.eobjects.analyzer.data.InputRow;
import org.eobjects.metamodel.util.HasName;

@TransformerBean(value="Tokenizer")
@Description(value="Tokenizes a String value (splits into substrings).")
@Categorized(value={StringManipulationCategory.class})
public class TokenizerTransformer
implements Transformer<String> {
    @Inject
    @Configured(value="Number of tokens")
    @Description(value="Defines the max amount of tokens to expect")
    @NumberProperty(zero=false, negative=false)
    Integer numTokens;
    @Inject
    @Configured
    InputColumn<String> column;
    @Inject
    @Configured
    @Description(value="Characters to tokenize by")
    char[] delimiters = new char[]{' ', '\t', '\n', '\r', '\f'};
    @Inject
    @Configured
    @Description(value="Add tokens as columns or as separate rows?")
    TokenTarget tokenTarget = TokenTarget.COLUMNS;
    @Inject
    @Provided
    OutputRowCollector outputRowCollector;

    public TokenizerTransformer() {
    }

    public TokenizerTransformer(InputColumn<String> column, Integer numTokens) {
        this.column = column;
        this.numTokens = numTokens;
    }

    public OutputColumns getOutputColumns() {
        if (this.tokenTarget == TokenTarget.COLUMNS) {
            String[] names = new String[this.numTokens.intValue()];
            for (int i = 0; i < names.length; ++i) {
                names[i] = this.column.getName() + " (token " + (i + 1) + ")";
            }
            return new OutputColumns(names);
        }
        return new OutputColumns(this.column.getName() + " (token)", new String[0]);
    }

    public String[] transform(InputRow inputRow) {
        int i;
        String value = (String)inputRow.getValue(this.column);
        String[] result = new String[this.numTokens.intValue()];
        if (value != null) {
            StringTokenizer st = new StringTokenizer(value, new String(this.delimiters));
            for (i = 0; i < result.length && st.hasMoreTokens(); ++i) {
                result[i] = st.nextToken();
            }
        }
        if (this.tokenTarget == TokenTarget.COLUMNS) {
            return result;
        }
        for (i = 0; i < result.length; ++i) {
            if (result[i] == null) continue;
            this.outputRowCollector.putValues(new Object[]{result[i]});
        }
        return null;
    }

    public static enum TokenTarget implements HasName
    {
        COLUMNS,
        ROWS;


        public String getName() {
            if (this == COLUMNS) {
                return "Columns";
            }
            return "Rows";
        }
    }
}

