/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.analyzer.beans.transform;

import org.eobjects.analyzer.beans.api.Categorized;
import org.eobjects.analyzer.beans.api.Configured;
import org.eobjects.analyzer.beans.api.Description;
import org.eobjects.analyzer.beans.api.OutputColumns;
import org.eobjects.analyzer.beans.api.Transformer;
import org.eobjects.analyzer.beans.api.TransformerBean;
import org.eobjects.analyzer.beans.categories.StringManipulationCategory;
import org.eobjects.analyzer.data.InputColumn;
import org.eobjects.analyzer.data.InputRow;
import org.eobjects.analyzer.util.StringUtils;

@TransformerBean(value="Whitespace trimmer")
@Description(value="Trims your String values either on left, right or both sides.")
@Categorized(value={StringManipulationCategory.class})
public class WhitespaceTrimmerTransformer
implements Transformer<String> {
    @Configured
    InputColumn<String>[] columns;
    @Configured(order=1)
    boolean trimLeft = true;
    @Configured(order=2)
    boolean trimRight = true;
    @Configured(order=3)
    boolean trimMultipleToSingleSpace = false;

    public WhitespaceTrimmerTransformer() {
    }

    public WhitespaceTrimmerTransformer(boolean trimLeft, boolean trimRight, boolean trimMultipleToSingleSpace) {
        this();
        this.trimLeft = trimLeft;
        this.trimRight = trimRight;
        this.trimMultipleToSingleSpace = trimMultipleToSingleSpace;
    }

    public OutputColumns getOutputColumns() {
        String[] names = new String[this.columns.length];
        for (int i = 0; i < this.columns.length; ++i) {
            String name;
            InputColumn<String> column = this.columns[i];
            names[i] = name = column.getName() + " (trimmed)";
        }
        return new OutputColumns(names);
    }

    public String[] transform(InputRow inputRow) {
        String[] result = new String[this.columns.length];
        for (int i = 0; i < this.columns.length; ++i) {
            InputColumn<String> column = this.columns[i];
            String value = (String)inputRow.getValue(column);
            result[i] = value = this.transform(value);
        }
        return result;
    }

    public String transform(String value) {
        if (value == null) {
            return null;
        }
        if (this.trimLeft && this.trimRight) {
            value = value.trim();
        } else {
            if (this.trimLeft) {
                value = StringUtils.leftTrim((String)value);
            }
            if (this.trimRight) {
                value = StringUtils.rightTrim((String)value);
            }
        }
        if (this.trimMultipleToSingleSpace) {
            value = StringUtils.replaceWhitespaces((String)value, (String)" ");
        }
        return value;
    }
}

