/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.analyzer.beans.transform;

import org.apache.commons.lang.StringEscapeUtils;
import org.eobjects.analyzer.beans.api.Categorized;
import org.eobjects.analyzer.beans.api.Configured;
import org.eobjects.analyzer.beans.api.Description;
import org.eobjects.analyzer.beans.api.OutputColumns;
import org.eobjects.analyzer.beans.api.Transformer;
import org.eobjects.analyzer.beans.api.TransformerBean;
import org.eobjects.analyzer.beans.categories.StringManipulationCategory;
import org.eobjects.analyzer.data.InputColumn;
import org.eobjects.analyzer.data.InputRow;
import org.eobjects.analyzer.data.MockInputColumn;

@TransformerBean(value="XML decoder")
@Description(value="Decodes XML content into plain text")
@Categorized(value={StringManipulationCategory.class})
public class XmlDecoderTransformer
implements Transformer<String> {
    @Configured
    InputColumn<String> column;

    public XmlDecoderTransformer() {
    }

    public XmlDecoderTransformer(MockInputColumn<String> column) {
        this();
        this.column = column;
    }

    public OutputColumns getOutputColumns() {
        return new OutputColumns(this.column.getName() + " (XML decoded)", new String[0]);
    }

    public String[] transform(InputRow inputRow) {
        String value = (String)inputRow.getValue(this.column);
        if (value != null) {
            value = StringEscapeUtils.unescapeXml((String)value);
        }
        return new String[]{value};
    }
}

