/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.analyzer.beans.convert;

import javax.inject.Inject;
import org.eobjects.analyzer.beans.api.Alias;
import org.eobjects.analyzer.beans.api.Categorized;
import org.eobjects.analyzer.beans.api.Configured;
import org.eobjects.analyzer.beans.api.Description;
import org.eobjects.analyzer.beans.api.OutputColumns;
import org.eobjects.analyzer.beans.api.Transformer;
import org.eobjects.analyzer.beans.api.TransformerBean;
import org.eobjects.analyzer.beans.categories.ConversionCategory;
import org.eobjects.analyzer.data.InputColumn;
import org.eobjects.analyzer.data.InputRow;

@TransformerBean(value="Convert to boolean")
@Description(value="Converts anything to a boolean (or null).")
@Categorized(value={ConversionCategory.class})
public class ConvertToBooleanTransformer
implements Transformer<Boolean> {
    public static final String[] DEFAULT_TRUE_TOKENS = new String[]{"true", "yes", "1", "x"};
    public static final String[] DEFAULT_FALSE_TOKENS = new String[]{"false", "no", "0", "-"};
    @Inject
    @Configured
    @Alias(value={"Column"})
    InputColumn<?>[] input;
    @Configured(required=false)
    Boolean nullReplacement;
    @Configured
    @Description(value="Text tokens that will translate to 'true'")
    String[] _trueTokens = DEFAULT_TRUE_TOKENS;
    @Configured
    @Description(value="Text tokens that will translate to 'false'")
    String[] _falseTokens = DEFAULT_FALSE_TOKENS;

    public ConvertToBooleanTransformer(InputColumn<?>[] input) {
        this.input = input;
    }

    public ConvertToBooleanTransformer() {
        this(null);
    }

    public OutputColumns getOutputColumns() {
        String[] names = new String[this.input.length];
        for (int i = 0; i < names.length; ++i) {
            names[i] = this.input[i].getName() + " (as boolean)";
        }
        return new OutputColumns(names);
    }

    public Boolean[] transform(InputRow inputRow) {
        Boolean[] result = new Boolean[this.input.length];
        for (int i = 0; i < this.input.length; ++i) {
            Object value = inputRow.getValue(this.input[i]);
            Boolean b = ConvertToBooleanTransformer.transformValue(value, this._trueTokens, this._falseTokens);
            if (b == null) {
                b = this.nullReplacement;
            }
            result[i] = b;
        }
        return result;
    }

    public static Boolean transformValue(Object value) {
        return ConvertToBooleanTransformer.transformValue(value, DEFAULT_TRUE_TOKENS, DEFAULT_FALSE_TOKENS);
    }

    public static Boolean transformValue(Object value, String[] trueTokens, String[] falseTokens) {
        Boolean b = null;
        if (value != null) {
            if (value instanceof String) {
                String stringValue = (String)value;
                stringValue = stringValue.trim();
                for (String token : trueTokens) {
                    if (!token.equalsIgnoreCase(stringValue)) continue;
                    b = true;
                    break;
                }
                if (b == null) {
                    for (String token : falseTokens) {
                        if (!token.equalsIgnoreCase(stringValue)) continue;
                        b = false;
                        break;
                    }
                }
            } else if (value instanceof Number) {
                Number numberValue = (Number)value;
                if (numberValue.intValue() == 1) {
                    b = true;
                } else if (numberValue.intValue() == 0) {
                    b = false;
                }
            } else if (value instanceof Boolean) {
                b = (Boolean)value;
            }
        }
        return b;
    }

    public void setFalseTokens(String[] falseTokens) {
        this._falseTokens = falseTokens;
    }

    public String[] getFalseTokens() {
        return this._falseTokens;
    }

    public void setInput(InputColumn<?> ... input) {
        this.input = input;
    }

    public InputColumn<?>[] getInput() {
        return this.input;
    }

    public void setNullReplacement(Boolean nullReplacement) {
        this.nullReplacement = nullReplacement;
    }

    public Boolean getNullReplacement() {
        return this.nullReplacement;
    }

    public void setTrueTokens(String[] trueTokens) {
        this._trueTokens = trueTokens;
    }

    public String[] getTrueTokens() {
        return this._trueTokens;
    }
}

