/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.analyzer.beans.convert;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import javax.inject.Inject;
import org.eobjects.analyzer.beans.api.Categorized;
import org.eobjects.analyzer.beans.api.Configured;
import org.eobjects.analyzer.beans.api.Description;
import org.eobjects.analyzer.beans.api.Initialize;
import org.eobjects.analyzer.beans.api.OutputColumns;
import org.eobjects.analyzer.beans.api.Transformer;
import org.eobjects.analyzer.beans.api.TransformerBean;
import org.eobjects.analyzer.beans.categories.ConversionCategory;
import org.eobjects.analyzer.beans.categories.DateAndTimeCategory;
import org.eobjects.analyzer.data.InputColumn;
import org.eobjects.analyzer.data.InputRow;
import org.eobjects.analyzer.util.convert.NowDate;
import org.eobjects.analyzer.util.convert.TodayDate;
import org.eobjects.analyzer.util.convert.YesterdayDate;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

@TransformerBean(value="Convert to date")
@Description(value="Converts anything to a date (or null).")
@Categorized(value={ConversionCategory.class, DateAndTimeCategory.class})
public class ConvertToDateTransformer
implements Transformer<Date> {
    private static final String[] prototypePatterns = new String[]{"yyyy-MM-dd", "dd-MM-yyyy", "MM-dd-yyyy"};
    private static final DateTimeFormatter NUMBER_BASED_DATE_FORMAT_LONG = DateTimeFormat.forPattern((String)"yyyyMMdd");
    private static final DateTimeFormatter NUMBER_BASED_DATE_FORMAT_SHORT = DateTimeFormat.forPattern((String)"yyMMdd");
    private static ConvertToDateTransformer internalInstance;
    @Inject
    @Configured(order=1)
    InputColumn<?>[] input;
    @Inject
    @Configured(required=false, order=2)
    Date nullReplacement;
    @Inject
    @Configured(required=false, order=3)
    String[] dateMasks = this.getDefaultDateMasks();
    private DateTimeFormatter[] _dateTimeFormatters;

    public static ConvertToDateTransformer getInternalInstance() {
        if (internalInstance == null) {
            internalInstance = new ConvertToDateTransformer();
            internalInstance.init();
        }
        return internalInstance;
    }

    @Initialize
    public void init() {
        if (this.dateMasks == null) {
            this.dateMasks = this.getDefaultDateMasks();
        }
        this._dateTimeFormatters = new DateTimeFormatter[this.dateMasks.length];
        for (int i = 0; i < this.dateMasks.length; ++i) {
            String dateMask = this.dateMasks[i];
            this._dateTimeFormatters[i] = DateTimeFormat.forPattern((String)dateMask);
        }
    }

    public OutputColumns getOutputColumns() {
        String[] names = new String[this.input.length];
        for (int i = 0; i < names.length; ++i) {
            names[i] = this.input[i].getName() + " (as date)";
        }
        return new OutputColumns(names);
    }

    public Date[] transform(InputRow inputRow) {
        Date[] result = new Date[this.input.length];
        for (int i = 0; i < this.input.length; ++i) {
            Object value = inputRow.getValue(this.input[i]);
            Date d = this.transformValue(value);
            if (d == null) {
                d = this.nullReplacement;
            }
            result[i] = d;
        }
        return result;
    }

    public Date transformValue(Object value) {
        Date d = null;
        if (value != null) {
            if (value instanceof Date) {
                d = (Date)value;
            } else if (value instanceof Calendar) {
                d = ((Calendar)value).getTime();
            } else if (value instanceof String) {
                d = this.convertFromString((String)value);
            } else if (value instanceof Number) {
                d = this.convertFromNumber((Number)value);
            }
        }
        return d;
    }

    protected Date convertFromString(String value) {
        try {
            long longValue = Long.parseLong(value);
            return this.convertFromNumber(longValue);
        }
        catch (NumberFormatException e) {
            if ("now()".equalsIgnoreCase(value)) {
                return new NowDate();
            }
            if ("today()".equalsIgnoreCase(value)) {
                return new TodayDate();
            }
            if ("yesterday()".equalsIgnoreCase(value)) {
                return new YesterdayDate();
            }
            for (DateTimeFormatter formatter : this._dateTimeFormatters) {
                try {
                    return formatter.parseDateTime(value).toDate();
                }
                catch (Exception e2) {
                }
            }
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss.S");
            try {
                return format.parse(value);
            }
            catch (ParseException parseException) {
                return null;
            }
        }
    }

    protected Date convertFromNumber(Number value) {
        Number numberValue = value;
        long longValue = numberValue.longValue();
        String stringValue = Long.toString(longValue);
        if (stringValue.length() == 8 && (stringValue.startsWith("1") || stringValue.startsWith("2"))) {
            try {
                return NUMBER_BASED_DATE_FORMAT_LONG.parseDateTime(stringValue).toDate();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (stringValue.length() == 6) {
            try {
                return NUMBER_BASED_DATE_FORMAT_SHORT.parseDateTime(stringValue).toDate();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (longValue > 5000000L) {
            return new Date(longValue);
        }
        return new Date(longValue * 1000L * 60L * 60L * 24L);
    }

    private String[] getDefaultDateMasks() {
        ArrayList<String> defaultDateMasks = new ArrayList<String>();
        defaultDateMasks.add("yyyy-MM-dd HH:mm:ss.S");
        defaultDateMasks.add("yyyy-MM-dd HH:mm:ss");
        defaultDateMasks.add("yyyy-MM-dd HH:mm");
        defaultDateMasks.add("yyyyMMddHHmmssZ");
        defaultDateMasks.add("yyMMddHHmmssZ");
        for (String string : prototypePatterns) {
            defaultDateMasks.add(string);
            string = string.replaceAll("\\-", "\\.");
            defaultDateMasks.add(string);
            string = string.replaceAll("\\.", "\\/");
            defaultDateMasks.add(string);
        }
        return defaultDateMasks.toArray(new String[defaultDateMasks.size()]);
    }

    public String[] getDateMasks() {
        return this.dateMasks;
    }

    public Date getNullReplacement() {
        return this.nullReplacement;
    }

    public void setNullReplacement(Date nullReplacement) {
        this.nullReplacement = nullReplacement;
    }
}

