/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.analyzer.beans.convert;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Date;
import javax.inject.Inject;
import org.eobjects.analyzer.beans.api.Categorized;
import org.eobjects.analyzer.beans.api.Configured;
import org.eobjects.analyzer.beans.api.Description;
import org.eobjects.analyzer.beans.api.OutputColumns;
import org.eobjects.analyzer.beans.api.Transformer;
import org.eobjects.analyzer.beans.api.TransformerBean;
import org.eobjects.analyzer.beans.categories.ConversionCategory;
import org.eobjects.analyzer.beans.categories.NumbersCategory;
import org.eobjects.analyzer.data.InputColumn;
import org.eobjects.analyzer.data.InputRow;
import org.eobjects.analyzer.util.Percentage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@TransformerBean(value="Convert to number")
@Description(value="Converts anything to a number (or null if not possible).")
@Categorized(value={ConversionCategory.class, NumbersCategory.class})
public class ConvertToNumberTransformer
implements Transformer<Number> {
    private static final Logger logger = LoggerFactory.getLogger(ConvertToNumberTransformer.class);
    @Inject
    @Configured
    InputColumn<?>[] input;
    @Inject
    @Configured
    char decimalSeparator = DecimalFormatSymbols.getInstance().getDecimalSeparator();
    @Inject
    @Configured
    char thousandSeparator = DecimalFormatSymbols.getInstance().getGroupingSeparator();
    @Inject
    @Configured
    char minusSign = DecimalFormatSymbols.getInstance().getMinusSign();
    @Inject
    @Configured(required=false)
    Number nullReplacement;

    public ConvertToNumberTransformer() {
    }

    public ConvertToNumberTransformer(char decimalSeparator, char thousandSeparator, char minusSign) {
        this();
        this.decimalSeparator = decimalSeparator;
        this.thousandSeparator = thousandSeparator;
        this.minusSign = minusSign;
    }

    public DecimalFormat getDecimalFormat() {
        DecimalFormat format = new DecimalFormat();
        DecimalFormatSymbols symbols = new DecimalFormatSymbols();
        symbols.setDecimalSeparator(this.decimalSeparator);
        symbols.setGroupingSeparator(this.thousandSeparator);
        symbols.setMinusSign(this.minusSign);
        format.setDecimalFormatSymbols(symbols);
        return format;
    }

    public OutputColumns getOutputColumns() {
        String[] names = new String[this.input.length];
        for (int i = 0; i < names.length; ++i) {
            names[i] = this.input[i].getName() + " (as number)";
        }
        return new OutputColumns(names);
    }

    public Number[] transform(InputRow inputRow) {
        Number[] result = new Number[this.input.length];
        for (int i = 0; i < this.input.length; ++i) {
            Object value = inputRow.getValue(this.input[i]);
            Number n = this.transform(value);
            if (n == null) {
                n = this.nullReplacement;
            }
            result[i] = n;
        }
        return result;
    }

    protected Number transform(Object value) {
        return ConvertToNumberTransformer.transformValue(value, this.getDecimalFormat());
    }

    public static Number transformValue(Object value) {
        DecimalFormat format = new DecimalFormat();
        DecimalFormatSymbols symbols = new DecimalFormatSymbols();
        symbols.setDecimalSeparator('.');
        symbols.setGroupingSeparator(',');
        symbols.setMinusSign('-');
        format.setDecimalFormatSymbols(symbols);
        return ConvertToNumberTransformer.transformValue(value, format);
    }

    public static Number transformValue(Object value, DecimalFormat decimalFormat) {
        Number n = null;
        if (value != null) {
            if (value instanceof Number) {
                n = (Number)value;
            } else if (value instanceof Boolean) {
                n = Boolean.TRUE.equals(value) ? Integer.valueOf(1) : Integer.valueOf(0);
            } else if (value instanceof Date) {
                Date d = (Date)value;
                n = d.getTime();
            } else if (value instanceof Character) {
                Character c = (Character)value;
                if (!Character.isDigit(c.charValue())) {
                    n = (int)c.charValue();
                }
            } else {
                String stringValue = value.toString().trim();
                try {
                    n = stringValue.indexOf(37) != -1 ? Percentage.parsePercentage(stringValue) : decimalFormat.parse(stringValue);
                }
                catch (Exception e) {
                    logger.info("Error occured parsing string as number: {}", (Object)stringValue);
                }
            }
        }
        return n;
    }

    public void setInput(InputColumn<?> ... input) {
        this.input = input;
    }

    public void setNullReplacement(Number nullReplacement) {
        this.nullReplacement = nullReplacement;
    }

    public void setDecimalSeparator(char decimalSeparator) {
        this.decimalSeparator = decimalSeparator;
    }

    public void setMinusSign(char minusSign) {
        this.minusSign = minusSign;
    }

    public void setThousandSeparator(char thousandSeparator) {
        this.thousandSeparator = thousandSeparator;
    }
}

