/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.analyzer.beans.convert;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Arrays;
import javax.inject.Inject;
import org.eobjects.analyzer.beans.api.Categorized;
import org.eobjects.analyzer.beans.api.Configured;
import org.eobjects.analyzer.beans.api.Description;
import org.eobjects.analyzer.beans.api.OutputColumns;
import org.eobjects.analyzer.beans.api.StringProperty;
import org.eobjects.analyzer.beans.api.Transformer;
import org.eobjects.analyzer.beans.api.TransformerBean;
import org.eobjects.analyzer.beans.categories.ConversionCategory;
import org.eobjects.analyzer.data.InputColumn;
import org.eobjects.analyzer.data.InputRow;
import org.eobjects.metamodel.util.FileHelper;

@TransformerBean(value="Convert to string")
@Description(value="Converts anything to a string (or null).")
@Categorized(value={ConversionCategory.class})
public class ConvertToStringTransformer
implements Transformer<String> {
    @Inject
    @Configured
    InputColumn<?>[] input;
    @StringProperty(multiline=true)
    @Configured(required=false)
    String nullReplacement;

    public OutputColumns getOutputColumns() {
        String[] names = new String[this.input.length];
        for (int i = 0; i < names.length; ++i) {
            names[i] = this.input[i].getName() + " (as string)";
        }
        return new OutputColumns(names);
    }

    public String[] transform(InputRow inputRow) {
        String[] result = new String[this.input.length];
        for (int i = 0; i < this.input.length; ++i) {
            Object value = inputRow.getValue(this.input[i]);
            String stringValue = ConvertToStringTransformer.transformValue(value);
            if (stringValue == null) {
                stringValue = this.nullReplacement;
            }
            result[i] = stringValue;
        }
        return result;
    }

    public static String transformValue(Object value) {
        String stringValue;
        block10: {
            block8: {
                if (value == null) {
                    return null;
                }
                if (value instanceof InputStream) {
                    value = new InputStreamReader(new BufferedInputStream((InputStream)value));
                }
                if (!(value instanceof Reader)) break block8;
                char[] buffer = new char[1024];
                Reader reader = (Reader)value;
                StringBuilder sb = new StringBuilder();
                try {
                    int read = reader.read(buffer);
                    while (read != -1) {
                        char[] charsToWrite = buffer;
                        if (read != buffer.length) {
                            charsToWrite = Arrays.copyOf(charsToWrite, read);
                        }
                        sb.append(charsToWrite);
                        read = reader.read(buffer);
                    }
                }
                catch (IOException e) {
                    try {
                        throw new IllegalStateException(e);
                    }
                    catch (Throwable throwable) {
                        FileHelper.safeClose((Object[])new Object[]{reader});
                        throw throwable;
                    }
                }
                FileHelper.safeClose((Object[])new Object[]{reader});
                stringValue = sb.toString();
                break block10;
            }
            stringValue = value.toString();
        }
        return stringValue;
    }

    public void setInput(InputColumn<?>[] input) {
        this.input = input;
    }

    public void setNullReplacement(String nullReplacement) {
        this.nullReplacement = nullReplacement;
    }
}

