/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.analyzer.beans.filter;

import java.util.concurrent.atomic.AtomicInteger;
import org.eobjects.analyzer.beans.api.Categorized;
import org.eobjects.analyzer.beans.api.Configured;
import org.eobjects.analyzer.beans.api.Description;
import org.eobjects.analyzer.beans.api.FilterBean;
import org.eobjects.analyzer.beans.api.NumberProperty;
import org.eobjects.analyzer.beans.api.QueryOptimizedFilter;
import org.eobjects.analyzer.beans.api.Validate;
import org.eobjects.analyzer.beans.categories.FilterCategory;
import org.eobjects.analyzer.data.InputRow;
import org.eobjects.metamodel.query.Query;

@FilterBean(value="Max rows")
@Description(value="Sets a maximum number of rows to process.")
@Categorized(value={FilterCategory.class})
public class MaxRowsFilter
implements QueryOptimizedFilter<Category> {
    @Configured
    @NumberProperty(negative=false, zero=false)
    @Description(value="The maximum number of rows to process.")
    int maxRows = 1000;
    @Configured
    @NumberProperty(negative=false, zero=false)
    @Description(value="The first row (aka 'offset') to process.")
    int firstRow = 1;
    private final AtomicInteger counter = new AtomicInteger();

    public MaxRowsFilter() {
    }

    public MaxRowsFilter(int firstRow, int maxRows) {
        this();
        this.firstRow = firstRow;
        this.maxRows = maxRows;
    }

    public void setMaxRows(int maxRows) {
        this.maxRows = maxRows;
    }

    public int getMaxRows() {
        return this.maxRows;
    }

    public int getFirstRow() {
        return this.firstRow;
    }

    public void setFirstRow(int firstRow) {
        this.firstRow = firstRow;
    }

    @Validate
    public void validate() {
        if (this.maxRows <= 0) {
            throw new IllegalStateException("Max rows value must be a positive integer");
        }
        if (this.firstRow <= 0) {
            throw new IllegalStateException("First row value must be a positive integer");
        }
    }

    public Category categorize(InputRow inputRow) {
        int count = this.counter.incrementAndGet();
        if (count < this.firstRow || count >= this.maxRows + this.firstRow) {
            return Category.INVALID;
        }
        return Category.VALID;
    }

    public boolean isOptimizable(Category category) {
        return category == Category.VALID;
    }

    public Query optimizeQuery(Query q, Category category) {
        if (category == Category.VALID) {
            q.setMaxRows(Integer.valueOf(this.maxRows));
            if (this.firstRow > 1) {
                q.setFirstRow(Integer.valueOf(this.firstRow));
            }
        } else {
            throw new IllegalStateException("Can only optimize the VALID max rows category");
        }
        return q;
    }

    public static enum Category {
        VALID,
        INVALID;

    }
}

