/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.analyzer.beans.transform;

import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import org.eobjects.analyzer.beans.api.Close;
import org.eobjects.analyzer.beans.api.Initialize;
import org.eobjects.analyzer.beans.api.OutputColumns;
import org.eobjects.analyzer.beans.api.OutputRowCollector;
import org.eobjects.analyzer.beans.api.Provided;
import org.eobjects.analyzer.beans.api.Transformer;
import org.eobjects.analyzer.configuration.AnalyzerBeansConfiguration;
import org.eobjects.analyzer.data.InputColumn;
import org.eobjects.analyzer.data.InputRow;
import org.eobjects.analyzer.data.MockInputRow;
import org.eobjects.analyzer.job.AnalysisJob;
import org.eobjects.analyzer.job.runner.ConsumeRowHandler;

public abstract class AbstractWrappedAnalysisJobTransformer
implements Transformer<Object> {
    @Inject
    @Provided
    AnalyzerBeansConfiguration _analyzerBeansConfiguration;
    @Inject
    @Provided
    OutputRowCollector _outputRowCollector;
    private AnalysisJob _wrappedAnalysisJob;
    private ConsumeRowHandler _consumeRowHandler;
    private Map<InputColumn<?>, InputColumn<?>> _inputColumnConversion;
    private List<InputColumn<?>> _outputColumns;

    protected abstract AnalysisJob getWrappedAnalysisJob();

    protected abstract Map<InputColumn<?>, InputColumn<?>> getInputColumnConversion(AnalysisJob var1);

    @Initialize
    public void init() {
        if (!this.reInitialize(this._wrappedAnalysisJob, this._outputColumns)) {
            return;
        }
        this._wrappedAnalysisJob = this.getWrappedAnalysisJob();
        if (this._wrappedAnalysisJob == null) {
            throw new IllegalStateException("Wrapped AnalysisJob cannot be null");
        }
        ConsumeRowHandler.Configuration configuration = new ConsumeRowHandler.Configuration();
        configuration.includeAnalyzers = false;
        this._consumeRowHandler = new ConsumeRowHandler(this._wrappedAnalysisJob, this._analyzerBeansConfiguration, configuration);
        this._inputColumnConversion = this.getInputColumnConversion(this._wrappedAnalysisJob);
        this._outputColumns = this._consumeRowHandler.getOutputColumns();
    }

    protected boolean reInitialize(AnalysisJob wrappedAnalysisJob, List<InputColumn<?>> outputColumns) {
        return wrappedAnalysisJob == null || outputColumns == null || outputColumns.isEmpty();
    }

    @Close
    public void close() {
        this._consumeRowHandler = null;
        this._inputColumnConversion = null;
        this._outputColumns = null;
    }

    public OutputColumns getOutputColumns() {
        this.init();
        int size = this._outputColumns.size();
        String[] names = new String[size];
        Class[] types = new Class[size];
        for (int i = 0; i < size; ++i) {
            InputColumn<?> outputColumn = this._outputColumns.get(0);
            names[i] = outputColumn.getName();
            types[i] = outputColumn.getDataType();
        }
        return new OutputColumns(names, types);
    }

    public Object[] transform(InputRow parentInputRow) {
        MockInputRow wrappedInputRow = new MockInputRow(parentInputRow.getId());
        Set<Map.Entry<InputColumn<?>, InputColumn<?>>> conversionEntries = this._inputColumnConversion.entrySet();
        for (Map.Entry<InputColumn<?>, InputColumn<?>> conversionEntry : conversionEntries) {
            InputColumn<?> parentColumn = conversionEntry.getKey();
            Object value = parentInputRow.getValue(parentColumn);
            InputColumn<?> wrappedColumn = conversionEntry.getValue();
            wrappedInputRow.put(wrappedColumn, value);
        }
        List<InputRow> outputRows = this._consumeRowHandler.consume(wrappedInputRow);
        for (InputRow wrappedOutputRow : outputRows) {
            Object[] outputValues = this.convertToOutputValues(wrappedOutputRow);
            this._outputRowCollector.putValues(outputValues);
        }
        return null;
    }

    private Object[] convertToOutputValues(InputRow wrappedOutputRow) {
        Object[] result = new Object[this._outputColumns.size()];
        for (int i = 0; i < result.length; ++i) {
            Object value;
            InputColumn<?> outputColumn = this._outputColumns.get(i);
            result[i] = value = wrappedOutputRow.getValue(outputColumn);
        }
        return result;
    }
}

