/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.analyzer.beans.transform;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.eobjects.analyzer.beans.api.Alias;
import org.eobjects.analyzer.beans.api.Close;
import org.eobjects.analyzer.beans.api.ColumnProperty;
import org.eobjects.analyzer.beans.api.Concurrent;
import org.eobjects.analyzer.beans.api.Configured;
import org.eobjects.analyzer.beans.api.Description;
import org.eobjects.analyzer.beans.api.Initialize;
import org.eobjects.analyzer.beans.api.OutputColumns;
import org.eobjects.analyzer.beans.api.OutputRowCollector;
import org.eobjects.analyzer.beans.api.Provided;
import org.eobjects.analyzer.beans.api.SchemaProperty;
import org.eobjects.analyzer.beans.api.TableProperty;
import org.eobjects.analyzer.beans.api.Transformer;
import org.eobjects.analyzer.beans.api.TransformerBean;
import org.eobjects.analyzer.beans.api.Validate;
import org.eobjects.analyzer.connection.Datastore;
import org.eobjects.analyzer.connection.DatastoreConnection;
import org.eobjects.analyzer.data.InputColumn;
import org.eobjects.analyzer.data.InputRow;
import org.eobjects.analyzer.util.CollectionUtils2;
import org.eobjects.metamodel.data.DataSet;
import org.eobjects.metamodel.query.CompiledQuery;
import org.eobjects.metamodel.query.OperatorType;
import org.eobjects.metamodel.query.Query;
import org.eobjects.metamodel.query.QueryParameter;
import org.eobjects.metamodel.schema.Column;
import org.eobjects.metamodel.util.HasName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@TransformerBean(value="Table lookup")
@Alias(value={"Datastore lookup"})
@Description(value="Perform a lookup based on a table in any of your registered datastore (like a LEFT join).")
@Concurrent(value=true)
public class TableLookupTransformer
implements Transformer<Object> {
    private static final Logger logger = LoggerFactory.getLogger(TableLookupTransformer.class);
    @Inject
    @Configured
    Datastore datastore;
    @Inject
    @Configured(required=false)
    InputColumn<?>[] conditionValues;
    @Inject
    @Configured(required=false)
    @ColumnProperty
    String[] conditionColumns;
    @Inject
    @Configured
    @ColumnProperty
    String[] outputColumns;
    @Inject
    @Configured
    @Alias(value={"Schema"})
    @SchemaProperty
    String schemaName;
    @Inject
    @Configured
    @Alias(value={"Table"})
    @TableProperty
    String tableName;
    @Inject
    @Configured
    @Description(value="Use a client-side cache to avoid looking up multiple times with same inputs.")
    boolean cacheLookups = true;
    @Inject
    @Configured
    @Description(value="Which kind of semantic to apply to the lookup, compared to a SQL JOIN.")
    JoinSemantic joinSemantic = JoinSemantic.LEFT_JOIN_MAX_ONE;
    @Inject
    @Provided
    OutputRowCollector outputRowCollector;
    private final Map<List<Object>, Object[]> cache = Collections.synchronizedMap(CollectionUtils2.createCacheMap());
    private Column[] queryOutputColumns;
    private Column[] queryConditionColumns;
    private DatastoreConnection datastoreConnection;
    private CompiledQuery lookupQuery;

    private void resetCachedColumns() {
        this.queryOutputColumns = null;
        this.queryConditionColumns = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Column[] getQueryConditionColumns() {
        if (this.queryConditionColumns == null) {
            if (this.isCarthesianProductMode()) {
                this.queryConditionColumns = new Column[0];
            } else {
                DatastoreConnection con = this.datastore.openConnection();
                try {
                    this.queryConditionColumns = con.getSchemaNavigator().convertToColumns(this.schemaName, this.tableName, this.conditionColumns);
                }
                finally {
                    con.close();
                }
            }
        }
        return this.queryConditionColumns;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Column[] getQueryOutputColumns(boolean checkNames) {
        if (this.queryOutputColumns == null) {
            DatastoreConnection con = this.datastore.openConnection();
            try {
                this.queryOutputColumns = con.getSchemaNavigator().convertToColumns(this.schemaName, this.tableName, this.outputColumns);
            }
            finally {
                con.close();
            }
        } else if (checkNames && !this.isQueryOutputColumnsUpdated()) {
            this.queryOutputColumns = null;
            return this.getQueryOutputColumns(false);
        }
        return this.queryOutputColumns;
    }

    private boolean isQueryOutputColumnsUpdated() {
        if (this.queryOutputColumns.length != this.outputColumns.length) {
            return false;
        }
        for (int i = 0; i < this.queryOutputColumns.length; ++i) {
            String expectedName = this.outputColumns[i];
            Column outputColumn = this.queryOutputColumns[i];
            if (!expectedName.equals(outputColumn.getName())) {
                return false;
            }
            if (this.tableName == null || this.tableName.equals(outputColumn.getTable().getName())) continue;
            return false;
        }
        return true;
    }

    @Initialize
    public void init() {
        this.datastoreConnection = this.datastore.openConnection();
        this.resetCachedColumns();
        this.cache.clear();
        this.compileLookupQuery();
    }

    private void compileLookupQuery() {
        try {
            Column[] queryOutputColumns = this.getQueryOutputColumns(false);
            Query query = new Query().from(queryOutputColumns[0].getTable()).select(queryOutputColumns);
            if (!this.isCarthesianProductMode()) {
                Column[] queryConditionColumns = this.getQueryConditionColumns();
                for (int i = 0; i < queryConditionColumns.length; ++i) {
                    query = query.where(queryConditionColumns[i], OperatorType.EQUALS_TO, (Object)new QueryParameter());
                }
            }
            if (this.joinSemantic == JoinSemantic.LEFT_JOIN_MAX_ONE) {
                query = query.setMaxRows(Integer.valueOf(1));
            }
            this.lookupQuery = this.datastoreConnection.getDataContext().compileQuery(query);
        }
        catch (RuntimeException e) {
            logger.error("Error occurred while compiling lookup query", (Throwable)e);
            throw e;
        }
    }

    private boolean isCarthesianProductMode() {
        return !(this.conditionColumns != null && this.conditionColumns.length != 0 || this.conditionValues != null && this.conditionValues.length != 0);
    }

    @Validate
    public void validate() {
        if (this.isCarthesianProductMode()) {
            return;
        }
        Column[] queryConditionColumns = this.getQueryConditionColumns();
        ArrayList<String> columnsNotFound = new ArrayList<String>();
        for (int i = 0; i < queryConditionColumns.length; ++i) {
            if (queryConditionColumns[i] != null) continue;
            columnsNotFound.add(this.conditionColumns[i]);
        }
        if (!columnsNotFound.isEmpty()) {
            throw new IllegalArgumentException("Could not find column(s): " + columnsNotFound);
        }
    }

    public OutputColumns getOutputColumns() {
        Column[] queryOutputColumns = this.getQueryOutputColumns(true);
        String[] names = new String[queryOutputColumns.length];
        Class[] types = new Class[queryOutputColumns.length];
        for (int i = 0; i < queryOutputColumns.length; ++i) {
            Column column = queryOutputColumns[i];
            if (column == null) {
                throw new IllegalArgumentException("Could not find column: " + this.outputColumns[i]);
            }
            names[i] = column.getName() + " (lookup)";
            types[i] = column.getType().getJavaEquivalentClass();
        }
        return new OutputColumns(names, types);
    }

    public Object[] transform(InputRow inputRow) {
        Object[] result;
        List<Object> queryInput;
        if (this.isCarthesianProductMode()) {
            queryInput = Collections.emptyList();
        } else {
            queryInput = new ArrayList(this.conditionValues.length);
            for (InputColumn<?> inputColumn : this.conditionValues) {
                Object value = inputRow.getValue(inputColumn);
                queryInput.add(value);
            }
        }
        logger.info("Looking up based on condition values: {}", queryInput);
        if (this.cacheLookups && this.joinSemantic.isCacheable()) {
            result = this.cache.get(queryInput);
            if (result == null) {
                result = this.performQuery(queryInput);
                this.cache.put(queryInput, result);
            } else if (logger.isDebugEnabled()) {
                logger.debug("Returning cached lookup result: {}", (Object)Arrays.toString(result));
            }
        } else {
            result = this.performQuery(queryInput);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object[] performQuery(List<Object> queryInput) {
        Object[] objectArray;
        Column[] queryConditionColumns = this.getQueryConditionColumns();
        Object[] parameterValues = new Object[queryConditionColumns.length];
        for (int i = 0; i < queryConditionColumns.length; ++i) {
            parameterValues[i] = queryInput.get(i);
        }
        DataSet dataSet = this.datastoreConnection.getDataContext().executeQuery(this.lookupQuery, parameterValues);
        try {
            objectArray = this.handleDataSet(dataSet);
        }
        catch (Throwable throwable) {
            try {
                dataSet.close();
                throw throwable;
            }
            catch (RuntimeException e) {
                logger.error("Error occurred while looking up based on conditions: " + queryInput, (Throwable)e);
                throw e;
            }
        }
        dataSet.close();
        return objectArray;
    }

    private Object[] handleDataSet(DataSet dataSet) {
        if (!dataSet.next()) {
            logger.warn("Result of lookup: None!");
            switch (this.joinSemantic) {
                case LEFT_JOIN_MAX_ONE: 
                case LEFT_JOIN: {
                    return new Object[this.outputColumns.length];
                }
            }
            return null;
        }
        do {
            Object[] result = dataSet.getRow().getValues();
            if (logger.isInfoEnabled()) {
                logger.info("Result of lookup: " + Arrays.toString(result));
            }
            switch (this.joinSemantic) {
                case LEFT_JOIN_MAX_ONE: {
                    return result;
                }
            }
            this.outputRowCollector.putValues(result);
        } while (dataSet.next());
        return null;
    }

    @Close
    public void close() {
        this.lookupQuery.close();
        this.datastoreConnection.close();
        this.cache.clear();
        this.queryOutputColumns = null;
        this.queryConditionColumns = null;
    }

    public static enum JoinSemantic implements HasName
    {
        LEFT_JOIN_MAX_ONE("Left join (max 1 record)"),
        INNER_JOIN("Inner join"),
        LEFT_JOIN("Left join");

        private final String _name;

        private JoinSemantic(String name) {
            this._name = name;
        }

        public String getName() {
            return this._name;
        }

        public boolean isCacheable() {
            return this == LEFT_JOIN_MAX_ONE;
        }
    }
}

