/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.analyzer.configuration;

import org.eobjects.analyzer.configuration.AnalyzerBeansConfiguration;
import org.eobjects.analyzer.configuration.InjectionManager;
import org.eobjects.analyzer.configuration.InjectionManagerFactory;
import org.eobjects.analyzer.configuration.InjectionManagerFactoryImpl;
import org.eobjects.analyzer.connection.Datastore;
import org.eobjects.analyzer.connection.DatastoreCatalog;
import org.eobjects.analyzer.connection.DatastoreCatalogImpl;
import org.eobjects.analyzer.descriptors.DescriptorProvider;
import org.eobjects.analyzer.descriptors.SimpleDescriptorProvider;
import org.eobjects.analyzer.job.AnalysisJob;
import org.eobjects.analyzer.job.concurrent.SingleThreadedTaskRunner;
import org.eobjects.analyzer.job.concurrent.TaskRunner;
import org.eobjects.analyzer.reference.ReferenceDataCatalog;
import org.eobjects.analyzer.reference.ReferenceDataCatalogImpl;
import org.eobjects.analyzer.storage.InMemoryStorageProvider;
import org.eobjects.analyzer.storage.StorageProvider;

public final class AnalyzerBeansConfigurationImpl
implements AnalyzerBeansConfiguration {
    private static final long serialVersionUID = 1L;
    private final transient DescriptorProvider _descriptorProvider;
    private final transient StorageProvider _storageProvider;
    private final transient TaskRunner _taskRunner;
    private final DatastoreCatalog _datastoreCatalog;
    private final ReferenceDataCatalog _referenceDataCatalog;
    private final InjectionManagerFactory _injectionManagerFactory;

    private static StorageProvider defaultStorageProvider() {
        return new InMemoryStorageProvider();
    }

    private static TaskRunner defaultTaskRunner() {
        return new SingleThreadedTaskRunner();
    }

    private static DescriptorProvider defaultDescriptorProvider() {
        return new SimpleDescriptorProvider();
    }

    private static ReferenceDataCatalog defaultReferenceDataCatalog() {
        return new ReferenceDataCatalogImpl();
    }

    private static DatastoreCatalog defaultDatastoreCatalog() {
        return new DatastoreCatalogImpl(new Datastore[0]);
    }

    public AnalyzerBeansConfigurationImpl() {
        this(AnalyzerBeansConfigurationImpl.defaultDatastoreCatalog(), AnalyzerBeansConfigurationImpl.defaultReferenceDataCatalog(), AnalyzerBeansConfigurationImpl.defaultDescriptorProvider(), AnalyzerBeansConfigurationImpl.defaultTaskRunner(), AnalyzerBeansConfigurationImpl.defaultStorageProvider());
    }

    public AnalyzerBeansConfigurationImpl(InjectionManagerFactory injectionManagerFactory) {
        this(AnalyzerBeansConfigurationImpl.defaultDatastoreCatalog(), AnalyzerBeansConfigurationImpl.defaultReferenceDataCatalog(), AnalyzerBeansConfigurationImpl.defaultDescriptorProvider(), AnalyzerBeansConfigurationImpl.defaultTaskRunner(), AnalyzerBeansConfigurationImpl.defaultStorageProvider(), injectionManagerFactory);
    }

    public AnalyzerBeansConfigurationImpl(DatastoreCatalog datastoreCatalog, ReferenceDataCatalog referenceDataCatalog, DescriptorProvider descriptorProvider, TaskRunner taskRunner, StorageProvider storageProvider) {
        this(datastoreCatalog, referenceDataCatalog, descriptorProvider, taskRunner, storageProvider, null);
    }

    public AnalyzerBeansConfigurationImpl(DatastoreCatalog datastoreCatalog, ReferenceDataCatalog referenceDataCatalog, DescriptorProvider descriptorProvider, TaskRunner taskRunner, StorageProvider storageProvider, InjectionManagerFactory injectionManagerFactory) {
        if (datastoreCatalog == null) {
            throw new IllegalArgumentException("datastoreCatalog cannot be null");
        }
        if (referenceDataCatalog == null) {
            throw new IllegalArgumentException("referenceDataCatalog cannot be null");
        }
        if (descriptorProvider == null) {
            throw new IllegalArgumentException("descriptorProvider cannot be null");
        }
        if (taskRunner == null) {
            throw new IllegalArgumentException("taskRunner cannot be null");
        }
        if (storageProvider == null) {
            throw new IllegalArgumentException("storageProvider cannot be null");
        }
        this._datastoreCatalog = datastoreCatalog;
        this._referenceDataCatalog = referenceDataCatalog;
        this._descriptorProvider = descriptorProvider;
        this._taskRunner = taskRunner;
        this._storageProvider = storageProvider;
        if (injectionManagerFactory == null) {
            injectionManagerFactory = new InjectionManagerFactoryImpl();
        }
        this._injectionManagerFactory = injectionManagerFactory;
    }

    public AnalyzerBeansConfigurationImpl replace(TaskRunner taskRunner) {
        return new AnalyzerBeansConfigurationImpl(this._datastoreCatalog, this._referenceDataCatalog, this._descriptorProvider, taskRunner, this._storageProvider, this._injectionManagerFactory);
    }

    public AnalyzerBeansConfigurationImpl replace(DescriptorProvider descriptorProvider) {
        return new AnalyzerBeansConfigurationImpl(this._datastoreCatalog, this._referenceDataCatalog, descriptorProvider, this._taskRunner, this._storageProvider, this._injectionManagerFactory);
    }

    public AnalyzerBeansConfigurationImpl replace(DatastoreCatalog datastoreCatalog) {
        return new AnalyzerBeansConfigurationImpl(datastoreCatalog, this._referenceDataCatalog, this._descriptorProvider, this._taskRunner, this._storageProvider, this._injectionManagerFactory);
    }

    public AnalyzerBeansConfigurationImpl replace(ReferenceDataCatalog referenceDataCatalog) {
        return new AnalyzerBeansConfigurationImpl(this._datastoreCatalog, referenceDataCatalog, this._descriptorProvider, this._taskRunner, this._storageProvider, this._injectionManagerFactory);
    }

    public AnalyzerBeansConfigurationImpl replace(StorageProvider storageProvider) {
        return new AnalyzerBeansConfigurationImpl(this._datastoreCatalog, this._referenceDataCatalog, this._descriptorProvider, this._taskRunner, storageProvider, this._injectionManagerFactory);
    }

    public AnalyzerBeansConfigurationImpl replace(InjectionManagerFactory injectionManagerFactory) {
        return new AnalyzerBeansConfigurationImpl(this._datastoreCatalog, this._referenceDataCatalog, this._descriptorProvider, this._taskRunner, this._storageProvider, injectionManagerFactory);
    }

    @Override
    public DatastoreCatalog getDatastoreCatalog() {
        return this._datastoreCatalog;
    }

    @Override
    public ReferenceDataCatalog getReferenceDataCatalog() {
        return this._referenceDataCatalog;
    }

    @Override
    public DescriptorProvider getDescriptorProvider() {
        return this._descriptorProvider;
    }

    @Override
    public StorageProvider getStorageProvider() {
        return this._storageProvider;
    }

    @Override
    public TaskRunner getTaskRunner() {
        return this._taskRunner;
    }

    @Override
    public InjectionManager getInjectionManager(AnalysisJob job) {
        return this._injectionManagerFactory.getInjectionManager(this, job);
    }
}

