/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.analyzer.configuration;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eobjects.analyzer.beans.api.OutputRowCollector;
import org.eobjects.analyzer.beans.api.Provided;
import org.eobjects.analyzer.configuration.AnalyzerBeansConfiguration;
import org.eobjects.analyzer.configuration.InjectionManager;
import org.eobjects.analyzer.configuration.InjectionPoint;
import org.eobjects.analyzer.connection.Datastore;
import org.eobjects.analyzer.connection.DatastoreCatalog;
import org.eobjects.analyzer.connection.DatastoreConnection;
import org.eobjects.analyzer.job.AnalysisJob;
import org.eobjects.analyzer.job.concurrent.ThreadLocalOutputRowCollector;
import org.eobjects.analyzer.reference.ReferenceDataCatalog;
import org.eobjects.analyzer.result.renderer.RendererFactory;
import org.eobjects.analyzer.storage.CollectionFactory;
import org.eobjects.analyzer.storage.CollectionFactoryImpl;
import org.eobjects.analyzer.storage.RowAnnotation;
import org.eobjects.analyzer.storage.RowAnnotationFactory;
import org.eobjects.analyzer.util.SchemaNavigator;
import org.eobjects.analyzer.util.convert.StringConverter;
import org.eobjects.metamodel.DataContext;
import org.eobjects.metamodel.util.LazyRef;
import org.eobjects.metamodel.util.Ref;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InjectionManagerImpl
implements InjectionManager {
    private static final Logger logger = LoggerFactory.getLogger(InjectionManagerImpl.class);
    private final AnalyzerBeansConfiguration _configuration;
    private final AnalysisJob _job;
    private final Ref<RowAnnotationFactory> _rowAnntationFactoryRef;

    public InjectionManagerImpl(AnalyzerBeansConfiguration configuration, AnalysisJob job) {
        this._configuration = configuration;
        this._job = job;
        this._rowAnntationFactoryRef = this.createRowAnnotationFactoryRef();
    }

    public InjectionManagerImpl(AnalyzerBeansConfiguration configuration) {
        this(configuration, null);
    }

    private Ref<RowAnnotationFactory> createRowAnnotationFactoryRef() {
        return new LazyRef<RowAnnotationFactory>(){

            protected RowAnnotationFactory fetch() {
                logger.info("Creating RowAnnotationFactory for job: {}", (Object)InjectionManagerImpl.this._job);
                RowAnnotationFactory rowAnnotationFactory = InjectionManagerImpl.this._configuration.getStorageProvider().createRowAnnotationFactory();
                if (rowAnnotationFactory == null) {
                    throw new IllegalStateException("Storage provider returned null RowAnnotationFactory!");
                }
                return rowAnnotationFactory;
            }
        };
    }

    @Override
    public final <E> E getInstance(InjectionPoint<E> injectionPoint) {
        Object instance = this.getInstanceInternal(injectionPoint);
        if (instance == null) {
            logger.warn("Could not handle injection for injection point: {}", injectionPoint);
        }
        return (E)instance;
    }

    protected Object getInstanceInternal(InjectionPoint<?> injectionPoint) {
        Class<?> baseType = injectionPoint.getBaseType();
        if (baseType == ReferenceDataCatalog.class) {
            return this._configuration.getReferenceDataCatalog();
        }
        if (baseType == OutputRowCollector.class) {
            return new ThreadLocalOutputRowCollector();
        }
        if (baseType == DatastoreCatalog.class) {
            return this._configuration.getDatastoreCatalog();
        }
        if (baseType == CollectionFactory.class) {
            return new CollectionFactoryImpl(this._configuration.getStorageProvider());
        }
        if (baseType == RendererFactory.class) {
            return new RendererFactory(this._configuration);
        }
        if (baseType == RowAnnotationFactory.class) {
            return this._rowAnntationFactoryRef.get();
        }
        if (baseType == AnalyzerBeansConfiguration.class) {
            return this._configuration;
        }
        if (baseType == AnalysisJob.class) {
            return this._job;
        }
        if (baseType == StringConverter.class) {
            InjectionManagerImpl childInjectionManager = this._configuration == null ? this : this._configuration.getInjectionManager(this._job);
            return new StringConverter(childInjectionManager);
        }
        if (baseType == RowAnnotation.class) {
            return ((RowAnnotationFactory)this._rowAnntationFactoryRef.get()).createAnnotation();
        }
        if (baseType == Datastore.class && this._job != null) {
            return this._job.getDatastore();
        }
        if (baseType == DatastoreConnection.class && this._job != null) {
            throw new UnsupportedOperationException("DatastoreConnections cannot be injected as of AnalyzerBeans 0.16. Inject a Datastore and manage a connection instead.");
        }
        if (baseType == DataContext.class && this._job != null) {
            throw new UnsupportedOperationException("DataContext cannot be injected as of AnalyzerBeans 0.16. Inject a Datastore and manage a connection instead.");
        }
        if (baseType == SchemaNavigator.class && this._job != null) {
            throw new UnsupportedOperationException("SchemaNavigator cannot be injected as of AnalyzerBeans 0.16. Inject a Datastore and manage a connection instead.");
        }
        if (injectionPoint.getAnnotation(Provided.class) != null && injectionPoint.isGenericType()) {
            Class<?> clazz1 = injectionPoint.getGenericTypeArgument(0);
            if (baseType == List.class) {
                List<?> list = this._configuration.getStorageProvider().createList(clazz1);
                return list;
            }
            if (baseType == Set.class) {
                Set<?> set = this._configuration.getStorageProvider().createSet(clazz1);
                return set;
            }
            if (baseType == Map.class) {
                Class<?> clazz2 = injectionPoint.getGenericTypeArgument(1);
                Map<?, ?> map = this._configuration.getStorageProvider().createMap(clazz1, clazz2);
                return map;
            }
        }
        return null;
    }
}

