/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.analyzer.connection;

import java.io.Closeable;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.List;
import org.eobjects.analyzer.connection.Datastore;
import org.eobjects.analyzer.connection.DatastoreConnection;
import org.eobjects.analyzer.connection.DatastoreConnectionImpl;
import org.eobjects.analyzer.connection.PerformanceCharacteristics;
import org.eobjects.analyzer.connection.PerformanceCharacteristicsImpl;
import org.eobjects.analyzer.connection.UsageAwareDatastore;
import org.eobjects.analyzer.connection.UsageAwareDatastoreConnection;
import org.eobjects.analyzer.util.ReadObjectBuilder;
import org.eobjects.metamodel.DataContext;
import org.eobjects.metamodel.DataContextFactory;

public final class CompositeDatastore
extends UsageAwareDatastore<DataContext> {
    private static final long serialVersionUID = 1L;
    private final List<? extends Datastore> _datastores;

    public CompositeDatastore(String name, List<? extends Datastore> datastores) {
        super(name);
        this._datastores = datastores;
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        ReadObjectBuilder.create(this, CompositeDatastore.class).readObject(stream);
    }

    public List<? extends Datastore> getDatastores() {
        return this._datastores;
    }

    @Override
    protected UsageAwareDatastoreConnection<DataContext> createDatastoreConnection() {
        ArrayList<DataContext> dataContexts = new ArrayList<DataContext>(this._datastores.size());
        ArrayList<DatastoreConnection> closeables = new ArrayList<DatastoreConnection>(this._datastores.size());
        for (Datastore datastore : this._datastores) {
            DatastoreConnection con = datastore.openConnection();
            DataContext dc = con.getDataContext();
            closeables.add(con);
            dataContexts.add(dc);
        }
        Closeable[] closeablesArray = closeables.toArray(new Closeable[closeables.size()]);
        return new DatastoreConnectionImpl<DataContext>(DataContextFactory.createCompositeDataContext(dataContexts), this, closeablesArray);
    }

    public PerformanceCharacteristics getPerformanceCharacteristics() {
        return new PerformanceCharacteristicsImpl(true);
    }

    @Override
    protected void decorateIdentity(List<Object> identifiers) {
        super.decorateIdentity(identifiers);
        identifiers.add(this._datastores);
    }
}

