/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.analyzer.connection;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eobjects.analyzer.connection.Datastore;
import org.eobjects.analyzer.connection.DatastoreCatalog;
import org.eobjects.metamodel.util.CollectionUtils;
import org.eobjects.metamodel.util.Func;
import org.eobjects.metamodel.util.HasNameMapper;

public class DatastoreCatalogImpl
implements DatastoreCatalog {
    private static final long serialVersionUID = 1L;
    private final Collection<Datastore> _datastores;

    public DatastoreCatalogImpl(Collection<Datastore> datastores) {
        if (datastores == null) {
            throw new IllegalArgumentException("datastores cannot be null");
        }
        this._datastores = datastores;
    }

    public DatastoreCatalogImpl(Datastore ... datastores) {
        this._datastores = new ArrayList<Datastore>();
        for (Datastore datastore : datastores) {
            this._datastores.add(datastore);
        }
    }

    @Override
    public String[] getDatastoreNames() {
        List names = CollectionUtils.map(this._datastores, (Func)new HasNameMapper());
        Collections.sort(names);
        return names.toArray(new String[names.size()]);
    }

    @Override
    public Datastore getDatastore(String name) {
        if (name != null) {
            for (Datastore ds : this._datastores) {
                if (!name.equals(ds.getName())) continue;
                return ds;
            }
        }
        return null;
    }
}

