/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.analyzer.connection;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.List;
import org.eobjects.analyzer.connection.DatastoreConnection;
import org.eobjects.analyzer.connection.FileDatastore;
import org.eobjects.analyzer.connection.PerformanceCharacteristics;
import org.eobjects.analyzer.connection.PerformanceCharacteristicsImpl;
import org.eobjects.analyzer.connection.ResourceDatastore;
import org.eobjects.analyzer.connection.UpdateableDatastore;
import org.eobjects.analyzer.connection.UpdateableDatastoreConnection;
import org.eobjects.analyzer.connection.UpdateableDatastoreConnectionImpl;
import org.eobjects.analyzer.connection.UsageAwareDatastore;
import org.eobjects.analyzer.connection.UsageAwareDatastoreConnection;
import org.eobjects.analyzer.util.ReadObjectBuilder;
import org.eobjects.metamodel.UpdateableDataContext;
import org.eobjects.metamodel.excel.ExcelConfiguration;
import org.eobjects.metamodel.excel.ExcelDataContext;
import org.eobjects.metamodel.util.Resource;
import org.eobjects.metamodel.util.SerializableRef;

public final class ExcelDatastore
extends UsageAwareDatastore<UpdateableDataContext>
implements FileDatastore,
ResourceDatastore,
UpdateableDatastore {
    private static final long serialVersionUID = 1L;
    private final String _filename;
    private final SerializableRef<Resource> _resourceRef;

    public ExcelDatastore(String name, Resource resource, String filename) {
        super(name);
        this._resourceRef = new SerializableRef((Object)resource);
        this._filename = filename;
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        ReadObjectBuilder.create(this, ExcelDatastore.class).readObject(stream);
    }

    @Override
    public Resource getResource() {
        if (this._resourceRef == null) {
            return null;
        }
        return (Resource)this._resourceRef.get();
    }

    @Override
    public String getFilename() {
        return this._filename;
    }

    @Override
    protected UsageAwareDatastoreConnection<UpdateableDataContext> createDatastoreConnection() {
        Resource resource = this.getResource();
        ExcelDataContext dc = resource == null ? new ExcelDataContext(new File(this._filename)) : new ExcelDataContext(resource, new ExcelConfiguration());
        return new UpdateableDatastoreConnectionImpl<ExcelDataContext>(dc, this, new Closeable[0]);
    }

    public UpdateableDatastoreConnection openConnection() {
        DatastoreConnection connection = super.openConnection();
        return (UpdateableDatastoreConnection)connection;
    }

    public PerformanceCharacteristics getPerformanceCharacteristics() {
        return new PerformanceCharacteristicsImpl(false);
    }

    @Override
    protected void decorateIdentity(List<Object> identifiers) {
        super.decorateIdentity(identifiers);
        identifiers.add(this._filename);
    }
}

