/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.analyzer.connection;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Arrays;
import java.util.List;
import org.eobjects.analyzer.connection.DatastoreConnectionImpl;
import org.eobjects.analyzer.connection.FileDatastore;
import org.eobjects.analyzer.connection.PerformanceCharacteristics;
import org.eobjects.analyzer.connection.PerformanceCharacteristicsImpl;
import org.eobjects.analyzer.connection.UsageAwareDatastore;
import org.eobjects.analyzer.connection.UsageAwareDatastoreConnection;
import org.eobjects.analyzer.util.ReadObjectBuilder;
import org.eobjects.metamodel.DataContext;
import org.eobjects.metamodel.DataContextFactory;
import org.eobjects.metamodel.fixedwidth.FixedWidthConfiguration;

public class FixedWidthDatastore
extends UsageAwareDatastore<DataContext>
implements FileDatastore {
    private static final long serialVersionUID = 1L;
    private final String _filename;
    private final String _encoding;
    private final int _fixedValueWidth;
    private final int[] _valueWidths;
    private final boolean _failOnInconsistencies;
    private final int _headerLineNumber;

    public FixedWidthDatastore(String name, String filename, String encoding, int fixedValueWidth) {
        this(name, filename, encoding, fixedValueWidth, true);
    }

    public FixedWidthDatastore(String name, String filename, String encoding, int[] valueWidths) {
        this(name, filename, encoding, valueWidths, true);
    }

    public FixedWidthDatastore(String name, String filename, String encoding, int fixedValueWidth, boolean failOnInconsistencies) {
        this(name, filename, encoding, fixedValueWidth, failOnInconsistencies, 1);
    }

    public FixedWidthDatastore(String name, String filename, String encoding, int[] valueWidths, boolean failOnInconsistencies) {
        this(name, filename, encoding, valueWidths, failOnInconsistencies, 1);
    }

    public FixedWidthDatastore(String name, String filename, String encoding, int fixedValueWidth, boolean failOnInconsistencies, int headerLineNumber) {
        super(name);
        this._filename = filename;
        this._encoding = encoding;
        this._fixedValueWidth = fixedValueWidth;
        this._valueWidths = new int[0];
        this._failOnInconsistencies = failOnInconsistencies;
        this._headerLineNumber = headerLineNumber;
    }

    public FixedWidthDatastore(String name, String filename, String encoding, int[] valueWidths, boolean failOnInconsistencies, int headerLineNumber) {
        super(name);
        this._filename = filename;
        this._encoding = encoding;
        this._fixedValueWidth = -1;
        this._valueWidths = valueWidths;
        this._failOnInconsistencies = failOnInconsistencies;
        this._headerLineNumber = headerLineNumber;
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        ReadObjectBuilder.create(this, FixedWidthDatastore.class).readObject(stream);
    }

    public PerformanceCharacteristics getPerformanceCharacteristics() {
        return new PerformanceCharacteristicsImpl(false);
    }

    @Override
    protected UsageAwareDatastoreConnection<DataContext> createDatastoreConnection() {
        File file = new File(this._filename);
        assert (file.exists());
        FixedWidthConfiguration configuration = this._fixedValueWidth == -1 ? new FixedWidthConfiguration(this._headerLineNumber, this._encoding, this._valueWidths, this._failOnInconsistencies) : new FixedWidthConfiguration(this._headerLineNumber, this._encoding, this._fixedValueWidth, this._failOnInconsistencies);
        DataContext dataContext = DataContextFactory.createFixedWidthDataContext((File)file, (FixedWidthConfiguration)configuration);
        return new DatastoreConnectionImpl<DataContext>(dataContext, this, new Closeable[0]);
    }

    public String getEncoding() {
        return this._encoding;
    }

    public int getFixedValueWidth() {
        return this._fixedValueWidth;
    }

    public int[] getValueWidths() {
        return this._valueWidths;
    }

    public int getHeaderLineNumber() {
        return this._headerLineNumber;
    }

    @Override
    public String getFilename() {
        return this._filename;
    }

    public boolean isFailOnInconsistencies() {
        return this._failOnInconsistencies;
    }

    @Override
    protected void decorateIdentity(List<Object> identifiers) {
        super.decorateIdentity(identifiers);
        identifiers.add(this._filename);
        identifiers.add(this._encoding);
        identifiers.add(this._fixedValueWidth);
        identifiers.add(this._valueWidths);
        identifiers.add(this._headerLineNumber);
        identifiers.add(this._failOnInconsistencies);
    }

    @Override
    public String toString() {
        return "FixedWidthDatastore[name=" + this.getName() + ", filename=" + this._filename + ", encoding=" + this._encoding + ", headerLineNumber=" + this._headerLineNumber + ", valueWidths=" + Arrays.toString(this._valueWidths) + ", fixedValueWidth=" + this._fixedValueWidth + "]";
    }
}

