/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.analyzer.connection;

import java.io.Closeable;
import org.eobjects.analyzer.connection.DatastoreConnection;
import org.eobjects.analyzer.connection.PerformanceCharacteristics;
import org.eobjects.analyzer.connection.PerformanceCharacteristicsImpl;
import org.eobjects.analyzer.connection.UpdateableDatastore;
import org.eobjects.analyzer.connection.UpdateableDatastoreConnection;
import org.eobjects.analyzer.connection.UpdateableDatastoreConnectionImpl;
import org.eobjects.analyzer.connection.UsageAwareDatastore;
import org.eobjects.analyzer.connection.UsageAwareDatastoreConnection;
import org.eobjects.analyzer.connection.UsernameDatastore;
import org.eobjects.metamodel.salesforce.SalesforceDataContext;

public class SalesforceDatastore
extends UsageAwareDatastore<SalesforceDataContext>
implements UpdateableDatastore,
UsernameDatastore {
    private static final long serialVersionUID = 1L;
    private final String _username;
    private final String _password;
    private final String _securityToken;

    public SalesforceDatastore(String name, String username, String password, String securityToken) {
        super(name);
        this._username = username;
        this._password = password;
        this._securityToken = securityToken;
    }

    @Override
    public String getUsername() {
        return this._username;
    }

    public String getPassword() {
        return this._password;
    }

    public String getSecurityToken() {
        return this._securityToken;
    }

    public UpdateableDatastoreConnection openConnection() {
        DatastoreConnection connection = super.openConnection();
        return (UpdateableDatastoreConnection)connection;
    }

    public PerformanceCharacteristics getPerformanceCharacteristics() {
        return new PerformanceCharacteristicsImpl(true);
    }

    @Override
    protected UsageAwareDatastoreConnection<SalesforceDataContext> createDatastoreConnection() {
        SalesforceDataContext dataContext = new SalesforceDataContext(this._username, this._password, this._securityToken);
        return new UpdateableDatastoreConnectionImpl<SalesforceDataContext>(dataContext, this, new Closeable[0]);
    }

    @Override
    public String toString() {
        return "SalesforceDatastore[username=" + this._username + "]";
    }
}

