/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.analyzer.connection;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.List;
import org.eobjects.analyzer.connection.Datastore;
import org.eobjects.analyzer.connection.DatastoreConnection;
import org.eobjects.analyzer.connection.DatastoreConnectionLease;
import org.eobjects.analyzer.connection.UpdateableDatastoreConnection;
import org.eobjects.analyzer.connection.UpdateableDatastoreConnectionLease;
import org.eobjects.analyzer.connection.UsageAwareDatastoreConnection;
import org.eobjects.analyzer.util.ReadObjectBuilder;
import org.eobjects.metamodel.DataContext;
import org.eobjects.metamodel.util.BaseObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class UsageAwareDatastore<E extends DataContext>
extends BaseObject
implements Datastore {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(UsageAwareDatastore.class);
    private volatile transient Reference<UsageAwareDatastoreConnection<E>> _datastoreConnectionRef;
    private volatile transient UsageAwareDatastoreConnection<E> _datastoreConnection = null;
    @ReadObjectBuilder.Moved
    private final String _name;
    private String _description;

    public UsageAwareDatastore(String name) {
        this._name = name;
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        ReadObjectBuilder.create(this, UsageAwareDatastore.class).readObject(stream);
    }

    public String getName() {
        return this._name;
    }

    public final String getDescription() {
        return this._description;
    }

    public final void setDescription(String description) {
        this._description = description;
    }

    protected Reference<UsageAwareDatastoreConnection<E>> getDataContextProviderRef() {
        return this._datastoreConnectionRef;
    }

    protected void setDataContextProviderRef(Reference<UsageAwareDatastoreConnection<E>> dataContextProviderRef) {
        this._datastoreConnectionRef = dataContextProviderRef;
    }

    protected void setDataContextProvider(UsageAwareDatastoreConnection<E> dataContextProvider) {
        this._datastoreConnection = dataContextProvider;
    }

    private final synchronized UsageAwareDatastoreConnection<E> getDatastoreConnection() {
        UsageAwareDatastoreConnection<E> datastoreConnection;
        if (this._datastoreConnection != null) {
            return this._datastoreConnection;
        }
        if (this._datastoreConnectionRef != null && (datastoreConnection = this._datastoreConnectionRef.get()) != null && datastoreConnection.requestUsage()) {
            logger.debug("Reusing existing DatastoreConnection: {}", datastoreConnection);
            return datastoreConnection;
        }
        datastoreConnection = this.createDatastoreConnection();
        if (datastoreConnection == null) {
            throw new IllegalStateException("createDatastoreConnection() returned null");
        }
        this._datastoreConnectionRef = new WeakReference<UsageAwareDatastoreConnection<E>>(datastoreConnection);
        return datastoreConnection;
    }

    public DatastoreConnection openConnection() {
        UsageAwareDatastoreConnection<E> connection = this.getDatastoreConnection();
        if (connection instanceof UpdateableDatastoreConnection) {
            return new UpdateableDatastoreConnectionLease((UpdateableDatastoreConnection)connection);
        }
        return new DatastoreConnectionLease(connection);
    }

    protected abstract UsageAwareDatastoreConnection<E> createDatastoreConnection();

    protected void decorateIdentity(List<Object> identifiers) {
        identifiers.add(this.getName());
        identifiers.add(this._description);
    }

    public final boolean isDatastoreConnectionOpen() {
        if (this._datastoreConnectionRef == null) {
            return false;
        }
        UsageAwareDatastoreConnection<E> dataContextProvider = this._datastoreConnectionRef.get();
        return this.isDataContextProviderOpen(dataContextProvider);
    }

    private boolean isDataContextProviderOpen(UsageAwareDatastoreConnection<E> dataContextProvider) {
        return dataContextProvider != null && !dataContextProvider.isClosed();
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + "[name=" + this.getName() + "]";
    }
}

