/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.analyzer.connection;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.List;
import org.eobjects.analyzer.connection.DatastoreConnectionImpl;
import org.eobjects.analyzer.connection.FileDatastore;
import org.eobjects.analyzer.connection.PerformanceCharacteristics;
import org.eobjects.analyzer.connection.PerformanceCharacteristicsImpl;
import org.eobjects.analyzer.connection.UsageAwareDatastore;
import org.eobjects.analyzer.connection.UsageAwareDatastoreConnection;
import org.eobjects.analyzer.util.ReadObjectBuilder;
import org.eobjects.metamodel.DataContext;
import org.eobjects.metamodel.DataContextFactory;
import org.eobjects.metamodel.xml.XmlSaxDataContext;
import org.eobjects.metamodel.xml.XmlSaxTableDef;

public class XmlDatastore
extends UsageAwareDatastore<DataContext>
implements FileDatastore {
    private static final long serialVersionUID = 1L;
    private final String _filename;
    private final XmlSaxTableDef[] _tableDefs;

    public XmlDatastore(String name, String filename) {
        this(name, filename, null);
    }

    public XmlDatastore(String name, String filename, XmlSaxTableDef[] tableDefs) {
        super(name);
        this._filename = filename;
        this._tableDefs = tableDefs;
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        ReadObjectBuilder.create(this, XmlDatastore.class).readObject(stream);
    }

    @Override
    public String getFilename() {
        return this._filename;
    }

    public XmlSaxTableDef[] getTableDefs() {
        return this._tableDefs;
    }

    @Override
    protected UsageAwareDatastoreConnection<DataContext> createDatastoreConnection() {
        File file = new File(this._filename);
        Object dataContext = this._tableDefs == null || this._tableDefs.length == 0 ? DataContextFactory.createXmlDataContext((File)file, (boolean)true) : new XmlSaxDataContext(file, this._tableDefs);
        return new DatastoreConnectionImpl<DataContext>((DataContext)dataContext, this, new Closeable[0]);
    }

    public PerformanceCharacteristics getPerformanceCharacteristics() {
        return new PerformanceCharacteristicsImpl(false);
    }

    @Override
    protected void decorateIdentity(List<Object> identifiers) {
        super.decorateIdentity(identifiers);
        identifiers.add(this._filename);
        identifiers.add(this._tableDefs);
    }
}

