/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.analyzer.data;

import org.eobjects.analyzer.data.AbstractInputColumn;
import org.eobjects.analyzer.data.DataTypeFamily;
import org.eobjects.analyzer.data.InputColumn;
import org.eobjects.analyzer.util.ReflectionUtils;
import org.eobjects.metamodel.schema.Column;
import org.eobjects.metamodel.schema.ColumnType;

public final class MetaModelInputColumn
extends AbstractInputColumn<Object> {
    private static final long serialVersionUID = 1L;
    private final Column _column;

    public MetaModelInputColumn(Column column) {
        if (column == null) {
            throw new IllegalArgumentException("column cannot be null");
        }
        this._column = column;
    }

    public <E> InputColumn<E> narrow(Class<E> e) {
        Class javaEquivalentClass = this._column.getType().getJavaEquivalentClass();
        if (ReflectionUtils.is(javaEquivalentClass, e)) {
            return this;
        }
        throw new IllegalArgumentException("Can only narrow this column to supertypes of: " + javaEquivalentClass);
    }

    public String getName() {
        return this._column.getName();
    }

    @Override
    protected Column getPhysicalColumnInternal() {
        return this._column;
    }

    @Override
    protected boolean equalsInternal(AbstractInputColumn<?> that) {
        MetaModelInputColumn that2 = (MetaModelInputColumn)that;
        return this._column.equals(that2._column);
    }

    public Class<? extends Object> getDataType() {
        ColumnType type = this._column.getType();
        if (type == null) {
            return null;
        }
        return type.getJavaEquivalentClass();
    }

    @Override
    protected int hashCodeInternal() {
        return this._column.hashCode();
    }

    public DataTypeFamily getDataTypeFamily() {
        ColumnType type = this._column.getType();
        if (type == null) {
            return DataTypeFamily.UNDEFINED;
        }
        if (type.isBoolean()) {
            return DataTypeFamily.BOOLEAN;
        }
        if (type.isLiteral()) {
            return DataTypeFamily.STRING;
        }
        if (type.isNumber()) {
            return DataTypeFamily.NUMBER;
        }
        if (type.isTimeBased()) {
            return DataTypeFamily.DATE;
        }
        return DataTypeFamily.UNDEFINED;
    }

    public String toString() {
        return "MetaModelInputColumn[" + this._column.getQualifiedLabel() + "]";
    }
}

