/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.analyzer.data;

import java.util.ArrayList;
import java.util.List;
import org.eobjects.analyzer.data.AbstractInputRow;
import org.eobjects.analyzer.data.InputColumn;
import org.eobjects.analyzer.data.MetaModelInputColumn;
import org.eobjects.metamodel.data.Row;
import org.eobjects.metamodel.query.SelectItem;
import org.eobjects.metamodel.schema.Column;

public final class MetaModelInputRow
extends AbstractInputRow {
    private static final long serialVersionUID = 1L;
    private final Row _row;
    private final int _rowNumber;

    public MetaModelInputRow(int rowNumber, Row row) {
        this._rowNumber = rowNumber;
        this._row = row;
    }

    public int getId() {
        return this._rowNumber;
    }

    public Row getRow() {
        return this._row;
    }

    public boolean containsInputColumn(InputColumn<?> inputColumn) {
        SelectItem[] selectItems;
        if (!inputColumn.isPhysicalColumn()) {
            return false;
        }
        Column physicalColumn = inputColumn.getPhysicalColumn();
        for (SelectItem selectItem : selectItems = this._row.getSelectItems()) {
            Column column;
            if (selectItem.getColumn() == null || selectItem.getFunction() != null || !physicalColumn.equals(column = selectItem.getColumn())) continue;
            return true;
        }
        return false;
    }

    @Override
    public <E> E getValueInternal(InputColumn<E> column) {
        if (!column.isPhysicalColumn()) {
            return null;
        }
        Column physicalColumn = column.getPhysicalColumn();
        Object value = this._row.getValue(physicalColumn);
        return (E)value;
    }

    public String toString() {
        return "MetaModelInputRow[" + this._row + "]";
    }

    public List<InputColumn<?>> getInputColumns() {
        SelectItem[] selectItems;
        ArrayList result = new ArrayList();
        for (SelectItem selectItem : selectItems = this._row.getSelectItems()) {
            if (selectItem.getColumn() == null || selectItem.getFunction() != null) continue;
            result.add(new MetaModelInputColumn(selectItem.getColumn()));
        }
        return result;
    }
}

