/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.analyzer.data;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.eobjects.analyzer.data.AbstractInputRow;
import org.eobjects.analyzer.data.InputColumn;

public class MockInputRow
extends AbstractInputRow {
    private static final long serialVersionUID = 1L;
    private static final AtomicInteger _idGenerator = new AtomicInteger(Integer.MIN_VALUE);
    private final Map<InputColumn<?>, Object> _values;
    private final int _id;

    public MockInputRow() {
        this(_idGenerator.getAndIncrement());
    }

    public MockInputRow(int id, Map<InputColumn<?>, Object> values) {
        this._values = values;
        this._id = id;
    }

    public MockInputRow(Map<InputColumn<?>, Object> values) {
        this(_idGenerator.getAndIncrement(), values);
    }

    public MockInputRow(int id) {
        this(id, new LinkedHashMap());
    }

    public MockInputRow(InputColumn<?>[] columns, Object[] values) {
        this(_idGenerator.getAndIncrement(), columns, values);
    }

    public MockInputRow(int id, InputColumn<?>[] columns, Object[] values) {
        this(id);
        for (int i = 0; i < values.length; ++i) {
            this.put(columns[i], values[i]);
        }
    }

    public int getId() {
        return this._id;
    }

    public List<InputColumn<?>> getInputColumns() {
        return new ArrayList(this._values.keySet());
    }

    public boolean containsInputColumn(InputColumn<?> inputColumn) {
        return this._values.containsKey(inputColumn);
    }

    @Override
    public <E> E getValueInternal(InputColumn<E> column) {
        return (E)this._values.get(column);
    }

    public MockInputRow put(InputColumn<?> column, Object value) {
        this._values.put(column, value);
        return this;
    }

    public MockInputRow putAll(Map<InputColumn<?>, Object> values) {
        this._values.putAll(values);
        return this;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this._id;
        result = 31 * result + (this._values == null ? 0 : ((Object)this._values).hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MockInputRow other = (MockInputRow)obj;
        if (this._id != other._id) {
            return false;
        }
        return !(this._values == null ? other._values != null : !((Object)this._values).equals(other._values));
    }

    public String toString() {
        return "MockInputRow[id=" + this._id + "]";
    }
}

